#include "../data.h"
#include "../game.h"
#include "flame.h"

void vg_object_flame_logic(VG_SPRITE * sp)
{
	int i;
	
	if(vg_sprite_near(&vg_sprite[sp->d1], 320))
	{
		sp->timer++;
		sp->x = vg_sprite[sp->d1].x + fmul(fcos(itofix(sp->timer)), itofix(sp->d2));
		sp->y = vg_sprite[sp->d1].y + fmul(fsin(itofix(sp->timer)), itofix(sp->d2));
		update_collision_map(&sp->cmap[sp->state], fixtoi(sp->x), fixtoi(sp->y));
		sp->frame++;
	}
}

void vg_object_flame_hit(VG_SPRITE * sp)
{
	if(vg_player.sprite.state != VG_CHARACTER_HIT_LEFT && vg_player.sprite.state != VG_CHARACTER_HIT_RIGHT)
	{
		if(fixtoi(vg_player.sprite.x) + vg_player.sprite.cmap[0].rx + vg_player.sprite.cmap[0].top.point[0].x < fixtoi(sp->x) + sp->cmap[0].rx + sp->cmap[0].top.point[0].x)
		{
			vg_player_set_state(VG_CHARACTER_HIT_RIGHT);
			vg_player.sprite.timer = 0;
			vg_player.sprite.vx = itofix(-5);
			if(vg_character_take_hit(&vg_player, 50))
			{
				ncds_play_sample(vg_sound[VG_SOUND_PLAYER_DIE], 127, -1, -1);
				if(vg_player.lives > 0)
				{
					vg_game_restart_level();
				}
				else
				{
					ncds_stop_music();
					fade_out(4);
					vg_state = VG_STATE_TITLE;
					vg_logic();
					vg_update();
					vg_draw();
					fade_in(vg_palette, 4);
					ncds_play_music("title.xm", 1);
					gametime_reset();
				}
			}
		}
		else
		{
			vg_player_set_state(VG_CHARACTER_HIT_LEFT);
			vg_player.sprite.timer = 0;
			vg_player.sprite.vx = itofix(5);
			if(vg_character_take_hit(&vg_player, 50))
			{
				ncds_play_sample(vg_sound[VG_SOUND_PLAYER_DIE], 127, -1, -1);
				if(vg_player.lives > 0)
				{
					vg_game_restart_level();
				}
				else
				{
					ncds_stop_music();
					fade_out(4);
					vg_state = VG_STATE_TITLE;
					vg_logic();
					vg_update();
					vg_draw();
					fade_in(vg_palette, 4);
					ncds_play_music("title.xm", 1);
					gametime_reset();
				}
			}
		}
	}
}
