#include "../data.h"
#include "../game.h"
#include "bullet.h"

void vg_object_bulletgun_logic(VG_SPRITE * sp)
{
	int i, j;
	
	if(!vg_sprite_near(sp, 16) && vg_sprite_near(sp, 320))
	{
		sp->timer++;
		if(sp->timer > 180 && rand() % 50 == 1)
		{
			sp->timer = 0;
			for(i = 0; i < VG_MAX_OBJECTS; i++)
			{
				if(!vg_sprite[i].active)
				{
					vg_sprite[i].type = VG_SPRITE_BULLET;
					vg_sprite[i].sp = vg_sprite_data[vg_sprite[i].type];
					vg_sprite[i].x = sp->x;
					vg_sprite[i].y = sp->y;
					vg_sprite[i].vx = itofix(-1);
					vg_sprite[i].active = 1;
					for(j = 0; j < VG_SPRITE_MAX_STATES; j++)
					{
						generate_collision_map(&vg_sprite[i].cmap[j], vg_sprite_data[vg_sprite[i].type]->cx[0], vg_sprite_data[vg_sprite[i].type]->cy[0], vg_sprite_data[vg_sprite[i].type]->cw[0], vg_sprite_data[vg_sprite[i].type]->ch[0], 16, 16);
						update_collision_map(&vg_sprite[i].cmap[j], fixtoi(vg_sprite[i].x), fixtoi(vg_sprite[i].y));
					}
					vg_sprite[i].state = vg_player.sprite.x < sp->x ? 0 : 1;
					vg_sprite[i].angle = itofix(0);
					vg_sprite[i].id = i;
					vg_sprite[i].death = 0;
					ncds_play_sample(vg_sound[VG_SOUND_PLAYER_BULLET], 127, -1, -1);
					break;
				}
			}
		}
	}
}

void vg_object_bulletgun_hit(VG_SPRITE * sp)
{
}
