#include "../data.h"
#include "../game.h"
#include "bullet.h"

void vg_object_bullet_logic(VG_SPRITE * sp)
{
	if(!sp->death)
	{
		if(sp->state == 0)
		{
			if(vg_sprite_near(sp, 400))
			{
				sp->x -= itofix(3);
				update_collision_map(&sp->cmap[sp->state], fixtoi(sp->x), fixtoi(sp->y));
			}
			else
			{
				sp->active = 0;
				printf("bullet destroyed (%d,%d)\n", fixtoi(sp->x), fixtoi(vg_player.sprite.x));
			}
		}
		else if(sp->state == 1)
		{
			if(vg_sprite_near(sp, 400))
			{
				sp->x += itofix(3);
				update_collision_map(&sp->cmap[sp->state], fixtoi(sp->x), fixtoi(sp->y));
			}
			else
			{
				sp->active = 0;
				printf("bullet destroyed\n");
			}
		}
	}
	else
	{
		sp->x += sp->vx;
		sp->y += sp->vy;
		sp->vy += ftofix(0.5);
		sp->angle += fmul(itofix(2), sp->vx);
		if(fixtoi(sp->y) - vg_level->tilemap->y > 240)
		{
			sp->active = 0;
		}
	}
}

void vg_object_bullet_hit(VG_SPRITE * sp)
{
	if(vg_player.sprite.state != VG_CHARACTER_HIT_LEFT && vg_player.sprite.state != VG_CHARACTER_HIT_RIGHT)
	{
		if(fixtoi(vg_player.sprite.x) + vg_player.sprite.cmap[0].rx + vg_player.sprite.cmap[0].top.point[0].x < fixtoi(sp->x) + sp->cmap[0].rx + sp->cmap[0].top.point[0].x)
		{
			vg_player_set_state(VG_CHARACTER_HIT_RIGHT);
			vg_player.sprite.vx = itofix(-5);
			vg_player.sprite.timer = 0;
			if(vg_character_take_hit(&vg_player, 50))
			{
				ncds_play_sample(vg_sound[VG_SOUND_PLAYER_DIE], 127, -1, -1);
				if(vg_player.lives > 0)
				{
					vg_game_restart_level();
				}
				else
				{
					ncds_stop_music();
					fade_out(4);
					vg_state = VG_STATE_TITLE;
					vg_logic();
					vg_update();
					vg_draw();
					fade_in(vg_palette, 4);
					ncds_play_music("title.xm", 1);
					gametime_reset();
				}
			}
		}
		else
		{
			vg_player_set_state(VG_CHARACTER_HIT_LEFT);
			vg_player.sprite.vx = itofix(5);
			vg_player.sprite.timer = 0;
			if(vg_character_take_hit(&vg_player, 50))
			{
				ncds_play_sample(vg_sound[VG_SOUND_PLAYER_DIE], 127, -1, -1);
				if(vg_player.lives > 0)
				{
					vg_game_restart_level();
				}
				else
				{
					ncds_stop_music();
					fade_out(4);
					vg_state = VG_STATE_TITLE;
					vg_logic();
					vg_update();
					vg_draw();
					fade_in(vg_palette, 4);
					ncds_play_music("title.xm", 1);
					gametime_reset();
				}
			}
		}
	}
}
