#ifndef OBJECTS_H
#define OBJECTS_H

#include "modules/animate.h"
#include "modules/collide.h"

#define VG_MAX_OBJECTS              256
#define VG_MAX_OBJECT_FLAGS          16

typedef struct
{

	ANIMATION * ap;
	COLLISION_MAP cmap;
	int type, active;

	/* for normal moving objects */
	fixed x, y, vx, vy;

	/* special flags */
	int flag[VG_MAX_OBJECT_FLAGS];

} VG_OBJECT;

int generate_object(int type, fixed x, fixed y);
int object_drop(VG_OBJECT * op, int type, fixed ox, fixed oy);
void object_initialize(VG_OBJECT * op);
void object_logic(VG_OBJECT * op);
void object_draw(BITMAP * bp, VG_OBJECT * op, int ox, int oy);

#endif
