#include <allegro.h>

void load_color_map(COLOR_MAP * mp, char * fn)
{
	int i, j;
	PACKFILE * fp;

	fp = pack_fopen(fn, "r");
	for(i = 0; i < PAL_SIZE; i++)
	{
		for(j = 0; j < PAL_SIZE; j++)
		{
			mp->data[i][j] = pack_getc(fp);
		}
	}
	pack_fclose(fp);
}

void save_color_map(COLOR_MAP * mp, char * fn)
{
	int i, j;
	PACKFILE * fp;

	fp = pack_fopen(fn, "w");
	for(i = 0; i < PAL_SIZE; i++)
	{
		for(j = 0; j < PAL_SIZE; j++)
		{
			pack_putc(mp->data[i][j], fp);
		}
	}
	pack_fclose(fp);
}

