#ifndef LEVEL_H
#define LEVEL_H

#include <allegro.h>
#include "modules/tilemap.h"
#include "objects.h"
#include "warp.h"

typedef struct
{

    /* tilemap data */
    TILESET * tileset;
    TILEMAP * tilemap;

	/* object positions */
    int object_type[VG_MAX_OBJECTS], object_x[VG_MAX_OBJECTS], object_y[VG_MAX_OBJECTS], object_active[VG_MAX_OBJECTS], object_flag[VG_MAX_OBJECTS][VG_MAX_OBJECT_FLAGS];
    
    /* warp data */
    VG_WARP warp[VG_MAX_WARPS];
    int warps;

} VG_LEVEL;

int load_level_data_fp(VG_LEVEL * lp, PACKFILE * fp);
int load_level_data(VG_LEVEL * lp, char * fn);
int save_level_data_fp(VG_LEVEL * lp, PACKFILE * fp);
int save_level_data(VG_LEVEL * lp, char * fn);
void save_level_fp(VG_LEVEL * lp, PACKFILE * fp);
void save_level(VG_LEVEL * lp, char * fn);
VG_LEVEL * load_level_fp(PACKFILE * fp);
VG_LEVEL * load_level(char * fn);
VG_LEVEL * create_level(PALETTE pal, int w, int h, int tw, int th, int l);
void destroy_level(VG_LEVEL * lp);

#endif
