#include <windows.h>

#include "resource.h" 

char launch_text[1024] = {0};
STARTUPINFO si;
PROCESS_INFORMATION pi;

BOOL CALLBACK DlgProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam)
{
	switch(Message)
	{
		case WM_INITDIALOG:
			// This is where we set up the dialog box, and initialise any default values

			win_set_window(hwnd);
			allegro_init();
			install_sound(DIGI_AUTODETECT, MIDI_NONE, NULL);
			SetDlgItemText(hwnd, IDC_TEXT, "");
			SetDlgItemInt(hwnd, IDC_NUMBER, 5, FALSE);
		break;
		case WM_COMMAND:
			switch(LOWORD(wParam))
			{
				case IDC_LAUNCH:
				{

					// Then we get the string they entered
					// First we need to find out how long it is so that we can
					// allocate some memory

					int len = GetWindowTextLength(GetDlgItem(hwnd, IDC_TEXT));
					if(len > 0)
					{
						// Now we allocate, and get the string into our buffer

						int i;
						char* buf;

						buf = (char*)GlobalAlloc(GPTR, len + 1);
						GetDlgItemText(hwnd, IDC_TEXT, buf, len + 1);

						sprintf(launch_text, "pp -ip %s", buf);
//						system(launch_text);
						CreateProcess("pp.exe", launch_text, NULL, NULL, 0, 0, NULL, NULL, &si, &pi);

						// Dont' forget to free the memory!
						GlobalFree((HANDLE)buf);
						EndDialog(hwnd, 0);
					}
					else 
					{
						MessageBox(hwnd, "No IP Entered.", "Error", MB_OK);
					}
				}
				break;
				case IDC_CANCEL:
				{
					EndDialog(hwnd, 0);
				}
				break;
				case IDC_LIST:
					switch(HIWORD(wParam))
					{
						case LBN_SELCHANGE:
						{
							// Get the number of items selected.

							HWND hList = GetDlgItem(hwnd, IDC_LIST);
							int count = SendMessage(hList, LB_GETSELCOUNT, 0, 0);
							if(count != LB_ERR)
							{
								// We only want to continue if one and only one item is
								// selected.

								if(count == 1)
								{
									// Since we know ahead of time we're only getting one
									// index, there's no need to allocate an array.

									int index;
									int err = SendMessage(hList, LB_GETSELITEMS, (WPARAM)1, (LPARAM)&index);
									if(err != LB_ERR)
									{
										// Get the data we associated with the item above
										// (the number of times it was added)

										int data = SendMessage(hList, LB_GETITEMDATA, (WPARAM)index, 0);

										SetDlgItemInt(hwnd, IDC_SHOWCOUNT, data, FALSE);
									}
									else 
									{
										MessageBox(hwnd, "Error getting selected item :(", "Warning", MB_OK);
									}
								}
								else 
								{
									// No items selected, or more than one
									// Either way, we aren't going to process this.
									SetDlgItemText(hwnd, IDC_SHOWCOUNT, "-");
								}
							}
							else
							{
								MessageBox(hwnd, "Error counting items :(", "Warning", MB_OK);
							}
						}
						break;
					}
				break;
			}
		break;
		case WM_CLOSE:
			EndDialog(hwnd, 0);
		break;
		default:
			return FALSE;
	}
	return TRUE;
}

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	return DialogBox(hInstance, MAKEINTRESOURCE(IDD_MAIN), NULL, DlgProc);
}
