#include "includes.h"

#include "objects/goomba.h"
#include "objects/turtle.h"
#include "objects/thwomp.h"
#include "objects/bulletgun.h"
#include "objects/bullet.h"
#include "objects/beetle.h"
#include "objects/flame.h"
#include "objects/rturtle.h"

int vg_sprite_near(VG_SPRITE * sp, int distance)
{
	int cdist = (fixtoi(sp->x) + sp->cmap->rx + sp->cmap[sp->state].top.point[0].x) - (fixtoi(vg_player.sprite.x) + vg_player.sprite.cmap[vg_player.sprite.state].rx + vg_player.sprite.cmap[vg_player.sprite.state].top.point[0].x);
	if(cdist < distance && cdist > -distance)
	{
		return 1;
	}
	return 0;
}

int vg_sprite_stomp(VG_SPRITE * sp1, VG_SPRITE * sp2)
{
	if(fixtoi(sp1->y) + sp1->cmap[sp1->state].ry + sp1->cmap[sp1->state].left.point[0].y < fixtoi(sp2->y) + sp2->cmap[sp2->state].ry + sp2->cmap[sp2->state].top.point[0].y)
	{
		return 1;
	}
	return 0;
}

int vg_create_projectile(ANIMATION * ap, int type, fixed x, fixed y, fixed vx, fixed vy)
{
	int i;
	
	for(i = 0; i < VG_MAX_PROJECTILES; i++)
	{
		if(!vg_projectile[i].active)
		{
			vg_projectile[i].ap = ap;
			vg_projectile[i].type = type;
			vg_projectile[i].x = x;
			vg_projectile[i].y = y;
			vg_projectile[i].vx = vx;
			vg_projectile[i].vy = vy;
			vg_projectile[i].active = 1;
			break;
		}
	}
	switch(vg_projectile[i].type)
	{
		case VG_PROJECTILE_PLAYER_SHOT:
		{
			generate_collision_map(&vg_projectile[i].cmap, 1, 1, 2, 2, 16, 16);
			update_collision_map(&vg_projectile[i].cmap, fixtoi(x), fixtoi(y));
			break;
		}
		case VG_PROJECTILE_MARIO_SHOT:
		{
			generate_collision_map(&vg_projectile[i].cmap, 2, 2, 4, 4, 16, 16);
			update_collision_map(&vg_projectile[i].cmap, fixtoi(x), fixtoi(y));
			break;
		}
	}
	return 1;
}

void vg_game_restart_level(void)
{
	int i;
	
	read_level_data(vg_level);
	vg_player.sprite.x = itofix(vg_last_warp.dx);
	vg_player.sprite.y = itofix(vg_last_warp.dy);
	vg_player.sprite.state = vg_last_warp.ds;
	vg_player.sprite.vx = itofix(0);
	vg_player.sprite.vy = itofix(0);
	vg_player.life = 100;
	update_collision_map(&vg_player.sprite.cmap[vg_player.sprite.state], fixtoi(vg_player.sprite.x), fixtoi(vg_player.sprite.y));
}

/* set up everything for a specific game mode */
int vg_game_init(int mode)
{
}

void vg_game_exit(void)
{
}

void vg_game_logic(void)
{
	int i, j;
	
	vg_script_logic();
	
	if(!vg_script_mid_execution)
	{
		controller_read(&vg_controller);
		vg_character_logic(&vg_player);
	}
	
	for(i = 0; i < TILEMAP_MAX_ROOMS; i++)
	{
		if(vg_level->tilemap->room[i].active)
		{
			if(fixtoi(vg_player.sprite.x) + vg_player.sprite.cmap[0].top.point[0].x > vg_level->tilemap->room[i].x * vg_level->tileset->w && fixtoi(vg_player.sprite.x) + vg_player.sprite.cmap[0].top.point[0].x < (vg_level->tilemap->room[i].x + vg_level->tilemap->room[i].w) * vg_level->tileset->w && fixtoi(vg_player.sprite.y) + vg_player.sprite.cmap[0].left.point[0].y > vg_level->tilemap->room[i].y * vg_level->tileset->h && fixtoi(vg_player.sprite.y) + vg_player.sprite.cmap[0].left.point[0].y < (vg_level->tilemap->room[i].y + vg_level->tilemap->room[i].h) * vg_level->tileset->h)
			{
				vg_level->tilemap->r = i;
				break;
			}
		}
	}
	for(i = 0; i < VG_MAX_WARPS; i++)
	{
		if(vg_level->warp[i].active)
		{
			if(point_collide(fixtoi(vg_player.sprite.x) + vg_player.sprite.cmap[vg_player.sprite.state].rx + vg_player.sprite.cmap[vg_player.sprite.state].top.point[0].x, fixtoi(vg_player.sprite.y) + vg_player.sprite.cmap[vg_player.sprite.state].ry + vg_player.sprite.cmap[vg_player.sprite.state].left.point[0].y, &vg_level->warp[i].cmap))
			{
				switch(vg_level->warp[i].type)
				{
					case WARP_TYPE_DOOR:
					{
						if(vg_controller.button[CONTROLLER_UP].pressed)
						{
							vg_player.warp = &vg_level->warp[i];
							vg_player.warp_type = VG_CHARACTER_WARP_TYPE_DOOR_IN;
							vg_player.warp_time = 0;
							vg_player.sprite.vx = itofix(0);
							vg_player.sprite.vy = itofix(0);
							vg_player.sprite.x = itofix(vg_level->warp[i].x - 4);
//							warp_execute(&vg_level->warp[i]);
							vg_level->warp[i].active = 0;
						}
						break;
					}
					case WARP_TYPE_PIPE_DOWN:
					{
						if(vg_controller.button[CONTROLLER_DOWN].held && tilemap_rubb_check(vg_level->tilemap, vg_level->tilemap->il, TILEMAP_FLAG_SOLIDT, &vg_player.sprite.cmap[vg_player.sprite.state]))
						{
							ncds_play_sample(vg_sound[VG_SOUND_PLAYER_WARP], 127, -1, -1);
							vg_player.warp = &vg_level->warp[i];
							vg_player.warp_type = VG_CHARACTER_WARP_TYPE_DOWN;
							vg_player.warp_time = 0;
							vg_player.sprite.vx = itofix(0);
							vg_player.sprite.vy = itofix(0);
//							warp_execute(&vg_level->warp[i]);
							vg_level->warp[i].active = 0;
						}
						break;
					}
					case WARP_TYPE_PIPE_UP:
					{
						if(vg_controller.button[CONTROLLER_UP].held && tilemap_rubt_check(vg_level->tilemap, vg_level->tilemap->il, TILEMAP_FLAG_SOLIDB, &vg_player.sprite.cmap[vg_player.sprite.state]))
						{
							ncds_play_sample(vg_sound[VG_SOUND_PLAYER_WARP], 127, -1, -1);
							vg_player.warp = &vg_level->warp[i];
							vg_player.warp_type = VG_CHARACTER_WARP_TYPE_UP;
							vg_player.warp_time = 0;
							vg_player.sprite.vx = itofix(0);
							vg_player.sprite.vy = itofix(0);
//							warp_execute(&vg_level->warp[i]);
							vg_level->warp[i].active = 0;
						}
						break;
					}
					case WARP_TYPE_PIPE_LR:
					{
						if(vg_controller.button[CONTROLLER_LEFT].held && tilemap_rubl_check(vg_level->tilemap, vg_level->tilemap->il, TILEMAP_FLAG_SOLIDR, &vg_player.sprite.cmap[vg_player.sprite.state]) && tilemap_rubb_check(vg_level->tilemap, vg_level->tilemap->il, TILEMAP_FLAG_SOLIDT, &vg_player.sprite.cmap[vg_player.sprite.state]))
						{
							ncds_play_sample(vg_sound[VG_SOUND_PLAYER_WARP], 127, -1, -1);
							vg_player.warp = &vg_level->warp[i];
							vg_player.warp_type = VG_CHARACTER_WARP_TYPE_LEFT;
							vg_player.warp_time = 0;
							vg_player.sprite.vx = itofix(0);
							vg_player.sprite.vy = itofix(0);
//							warp_execute(&vg_level->warp[i]);
							vg_level->warp[i].active = 0;
						}
						else if(vg_controller.button[CONTROLLER_RIGHT].held && tilemap_rubr_check(vg_level->tilemap, vg_level->tilemap->il, TILEMAP_FLAG_SOLIDL, &vg_player.sprite.cmap[vg_player.sprite.state]) && tilemap_rubb_check(vg_level->tilemap, vg_level->tilemap->il, TILEMAP_FLAG_SOLIDT, &vg_player.sprite.cmap[vg_player.sprite.state]))
						{
							ncds_play_sample(vg_sound[VG_SOUND_PLAYER_WARP], 127, -1, -1);
							vg_player.warp = &vg_level->warp[i];
							vg_player.warp_type = VG_CHARACTER_WARP_TYPE_RIGHT;
							vg_player.warp_time = 0;
							vg_player.sprite.vx = itofix(0);
							vg_player.sprite.vy = itofix(0);
//							warp_execute(&vg_level->warp[i]);
							vg_level->warp[i].active = 0;
						}
						break;
					}
				}
				break;
			}
		}
	}
	
	/* projectile logic */
	for(i = 0; i < VG_MAX_PROJECTILES; i++)
	{
		if(vg_projectile[i].active)
		{
			switch(vg_projectile[i].type)
			{
				case VG_PROJECTILE_PLAYER_SHOT:
				{
					vg_projectile[i].x += vg_projectile[i].vx;
					vg_projectile[i].y += vg_projectile[i].vy;
					update_collision_map(&vg_projectile[i].cmap, fixtoi(vg_projectile[i].x), fixtoi(vg_projectile[i].y));
					if(tilemap_collide(vg_level->tilemap, &vg_projectile[i].cmap))
					{
						vg_projectile[i].active = 0;
					}
					if(fixtoi(vg_projectile[i].x) < vg_level->tilemap->x - 32 || fixtoi(vg_projectile[i].x) > vg_level->tilemap->x + 320 + 32)
					{
						vg_projectile[i].active = 0;
					}
					for(j = 0; j < VG_MAX_OBJECTS; j++)
					{
						if(vg_projectile[i].active && vg_sprite[j].active && collide(&vg_projectile[i].cmap, &vg_sprite[j].cmap[vg_sprite[j].state]))
						{
							switch(vg_sprite[j].type)
							{
								case VG_SPRITE_GOOMBA:
								{
									if(!vg_sprite[j].death)
									{
										vg_projectile[i].active = 0;
										vg_sprite[j].death = 1;
										vg_sprite[j].state = 1;
										if(vg_projectile[i].vx < itofix(0))
										{
											vg_sprite[j].vx = ftofix(-1.0);
										}
										else
										{
											vg_sprite[j].vx = ftofix(1.0);
										}
										vg_sprite[j].vy = itofix(-5);
										vg_player.score += 200;
										ncds_play_sample(vg_sound[VG_SOUND_PLAYER_KILL], 127, -1, -1);
									}
									break;
								}
								case VG_SPRITE_TURTLE:
								case VG_SPRITE_RTURTLE:
								{
									if(vg_sprite[j].state != 2)
									{
										vg_projectile[i].active = 0;
										vg_sprite[j].death = 1;
										vg_sprite[j].state = 2;
										if(vg_projectile[i].vx < itofix(0))
										{
											vg_sprite[j].vx = ftofix(-1.0);
										}
										else
										{
											vg_sprite[j].vx = ftofix(1.0);
										}
										vg_sprite[j].vy = itofix(-5);
										vg_player.score += 500;
										ncds_play_sample(vg_sound[VG_SOUND_PLAYER_KILL], 127, -1, -1);
									}
									break;
								}
								case VG_SPRITE_BULLET:
								case VG_SPRITE_BEETLE:
								case VG_SPRITE_THWOMP:
								{
									vg_projectile[i].active = 0;
									break;
								}
								case VG_SPRITE_MARIO:
								{
									vg_projectile[i].active = 0;
									vg_sprite[j].life -= 5;
									if(vg_sprite[j].life <= 0)
									{
										vg_sprite[j].active = 0;
										ncds_stop_music();
										fade_out(4);
										vg_state = VG_STATE_TITLE;
										vg_logic();
										vg_update();
										vg_draw();
										fade_in(vg_palette, 4);
										ncds_play_music("title.xm", 1);
										gametime_reset();
									}
									vg_sprite[j].d1 = 15;
									break;
								}
							}
						}
					}
					break;
				}
				case VG_PROJECTILE_MARIO_SHOT:
				{
					vg_projectile[i].frame++;
					vg_projectile[i].y += vg_projectile[i].vy;
					update_collision_map(&vg_projectile[i].cmap, fixtoi(vg_projectile[i].x), fixtoi(vg_projectile[i].y));
					vg_projectile[i].vy += ftofix(VG_CHARACTER_GRAVITY);
					if(vg_projectile[i].vy > itofix(VG_CHARACTER_MAX_FALL_VELOCITY))
					{
						vg_projectile[i].vy = itofix(VG_CHARACTER_MAX_FALL_VELOCITY);
					}
					if(tilemap_collide(vg_level->tilemap, &vg_projectile[i].cmap))
					{
						vg_projectile[i].vy = itofix(-4);
						vg_projectile[i].y = itofix(get_sprite_y(&vg_projectile[i].cmap, 16));
						update_collision_map(&vg_projectile[i].cmap, fixtoi(vg_projectile[i].x), fixtoi(vg_projectile[i].y));
					}
					vg_projectile[i].x += vg_projectile[i].vx;
					update_collision_map(&vg_projectile[i].cmap, fixtoi(vg_projectile[i].x), fixtoi(vg_projectile[i].y));
					if(tilemap_collide(vg_level->tilemap, &vg_projectile[i].cmap))
					{
						vg_projectile[i].active = 0;
					}
					if(fixtoi(vg_projectile[i].x) < vg_level->tilemap->x - 32 || fixtoi(vg_projectile[i].x) > vg_level->tilemap->x + 320 + 32)
					{
						vg_projectile[i].active = 0;
					}
					if(collide(&vg_projectile[i].cmap, &vg_player.sprite.cmap[vg_player.sprite.state]))
					{
						vg_projectile[i].active = 0;
						vg_player_set_state(VG_CHARACTER_HIT_RIGHT);
						vg_player.sprite.timer = 0;
						vg_player.sprite.vx = itofix(-5);
						if(vg_character_take_hit(&vg_player, 50))
						{
							ncds_play_sample(vg_sound[VG_SOUND_PLAYER_DIE], 127, -1, -1);
							if(vg_player.lives > 0)
							{
								vg_game_restart_level();
							}
							else
							{
								ncds_stop_music();
								fade_out(4);
								vg_state = VG_STATE_TITLE;
								vg_logic();
								vg_update();
								vg_draw();
								fade_in(vg_palette, 4);
								ncds_play_music("title.xm", 1);
								gametime_reset();
							}
						}
					}
					break;
				}
			}
		}
	}
	
	/* sprite logic */
	for(i = 0; i < VG_MAX_OBJECTS; i++)
	{
		if(vg_sprite[i].active)
		{
			switch(vg_sprite[i].type)
			{
				case VG_SPRITE_GOOMBA:
				{
					vg_object_goomba_logic(&vg_sprite[i]);
					break;
				}
				case VG_SPRITE_TURTLE:
				{
					vg_object_beetle_logic(&vg_sprite[i]);
					break;
				}
				case VG_SPRITE_RTURTLE:
				{
					vg_object_rturtle_logic(&vg_sprite[i]);
					break;
				}
				case VG_SPRITE_THWOMP:
				{
					vg_object_thwomp_logic(&vg_sprite[i]);
					break;
				}
				case VG_SPRITE_BULLETGUN:
				{
					vg_object_bulletgun_logic(&vg_sprite[i]);
					break;
				}
				case VG_SPRITE_BULLET:
				{
					vg_object_bullet_logic(&vg_sprite[i]);
					break;
				}
				case VG_SPRITE_BEETLE:
				{
					vg_object_beetle_logic(&vg_sprite[i]);
					break;
				}
				case VG_SPRITE_FLAME:
				{
					vg_object_flame_logic(&vg_sprite[i]);
					break;
				}
				case VG_SPRITE_MARIO:
				{
					vg_object_mario_logic(&vg_sprite[i]);
					break;
				}
				case VG_SPRITE_COIN:
				{
					vg_sprite[i].frame++;
					break;
				}
			}
			if(collide(&vg_sprite[i].cmap[vg_sprite[i].state], &vg_player.sprite.cmap[vg_player.sprite.state]) && vg_sprite[i].type == VG_SPRITE_DEATH)
			{
				if(vg_character_take_hit(&vg_player, 100))
				{
					ncds_play_sample(vg_sound[VG_SOUND_PLAYER_DIE], 127, -1, -1);
					if(vg_player.lives > 0)
					{
						vg_game_restart_level();
					}
					else
					{
						ncds_stop_music();
						fade_out(4);
						vg_state = VG_STATE_TITLE;
						vg_logic();
						vg_update();
						vg_draw();
						fade_in(vg_palette, 4);
						ncds_play_music("title.xm", 1);
						gametime_reset();
					}
				}
			}
			else if(!vg_sprite[i].death && !vg_player.sprite.d1 && collide(&vg_sprite[i].cmap[vg_sprite[i].state], &vg_player.sprite.cmap[vg_player.sprite.state]))
			{
				switch(vg_sprite[i].type)
				{
					case VG_SPRITE_GOOMBA:
					{
						if(vg_sprite_stomp(&vg_player.sprite, &vg_sprite[i]) && vg_player.sprite.vy >= itofix(0))
						{
							if(!vg_sprite[i].death)
							{
								vg_sprite[i].death = 1;
								vg_sprite[i].state = 1;
								if(vg_player.sprite.x < vg_sprite[i].x)
								{
									vg_sprite[i].vx = ftofix(1.0);
								}
								else
								{
									vg_sprite[i].vx = ftofix(-1.0);
								}
								vg_sprite[i].vy = itofix(-5);
								vg_player.score += 200;
								vg_player.sprite.vy = itofix(-7);
								ncds_play_sample(vg_sound[VG_SOUND_PLAYER_KILL], 127, -1, -1);
							}
						}
						else
						{
							vg_object_goomba_hit(&vg_sprite[i]);
						}
						break;
					}
					case VG_SPRITE_TURTLE:
					{
						if(vg_sprite_stomp(&vg_player.sprite, &vg_sprite[i]) && vg_player.sprite.vy >= itofix(0))
						{
							if(!vg_sprite[i].death)
							{
								vg_sprite[i].death = 1;
								vg_sprite[i].state = 2;
								if(vg_player.sprite.x < vg_sprite[i].x)
								{
									vg_sprite[i].vx = ftofix(1.0);
								}
								else
								{
									vg_sprite[i].vx = ftofix(-1.0);
								}
								vg_sprite[i].vy = itofix(-5);
								vg_player.score += 200;
								vg_player.sprite.vy = itofix(-7);
								ncds_play_sample(vg_sound[VG_SOUND_PLAYER_KILL], 127, -1, -1);
							}
						}
						else
						{
							vg_object_turtle_hit(&vg_sprite[i]);
						}
						break;
					}
					case VG_SPRITE_RTURTLE:
					{
						if(vg_sprite_stomp(&vg_player.sprite, &vg_sprite[i]) && vg_player.sprite.vy >= itofix(0))
						{
							if(!vg_sprite[i].death)
							{
								vg_sprite[i].death = 1;
								vg_sprite[i].state = 2;
								if(vg_player.sprite.x < vg_sprite[i].x)
								{
									vg_sprite[i].vx = ftofix(1.0);
								}
								else
								{
									vg_sprite[i].vx = ftofix(-1.0);
								}
								vg_sprite[i].vy = itofix(-5);
								vg_player.score += 200;
								vg_player.sprite.vy = itofix(-7);
								ncds_play_sample(vg_sound[VG_SOUND_PLAYER_KILL], 127, -1, -1);
							}
						}
						else
						{
							vg_object_rturtle_hit(&vg_sprite[i]);
						}
						break;
					}
					case VG_SPRITE_THWOMP:
					{
						vg_object_thwomp_hit(&vg_sprite[i]);
						break;
					}
					case VG_SPRITE_BULLET:
					{
						if(vg_sprite_stomp(&vg_player.sprite, &vg_sprite[i]) && vg_player.sprite.vy >= itofix(0))
						{
							if(!vg_sprite[i].death)
							{
								vg_sprite[i].death = 1;
								if(vg_player.sprite.x < vg_sprite[i].x)
								{
									vg_sprite[i].vx = ftofix(1.0);
								}
								else
								{
									vg_sprite[i].vx = ftofix(-1.0);
								}
								vg_sprite[i].vy = itofix(-5);
								vg_sprite[i].death = 1;
								vg_player.score += 200;
								vg_player.sprite.vy = itofix(-7);
								ncds_play_sample(vg_sound[VG_SOUND_PLAYER_KILL], 127, -1, -1);
							}
						}
						else
						{
							vg_object_bullet_hit(&vg_sprite[i]);
						}
						break;
					}
					case VG_SPRITE_BEETLE:
					{
						if(vg_sprite_stomp(&vg_player.sprite, &vg_sprite[i]) && vg_player.sprite.vy >= itofix(0))
						{
							if(!vg_sprite[i].death)
							{
								vg_sprite[i].death = 1;
								vg_sprite[i].state = 2;
								if(vg_player.sprite.x < vg_sprite[i].x)
								{
									vg_sprite[i].vx = ftofix(1.0);
								}
								else
								{
									vg_sprite[i].vx = ftofix(-1.0);
								}
								vg_sprite[i].vy = itofix(-5);
								vg_player.score += 200;
								vg_player.sprite.vy = itofix(-7);
								ncds_play_sample(vg_sound[VG_SOUND_PLAYER_KILL], 127, -1, -1);
							}
						}
						else
						{
							vg_object_beetle_hit(&vg_sprite[i]);
						}
						break;
					}
					case VG_SPRITE_FLAME:
					{
						vg_object_flame_hit(&vg_sprite[i]);
						break;
					}
					case VG_SPRITE_MARIO:
					{
						vg_object_mario_hit(&vg_sprite[i]);
						break;
					}
					case VG_SPRITE_COIN:
					{
						vg_player.score += 100;
						vg_sprite[i].active = 0;
						ncds_play_sample(vg_sound[VG_SOUND_PLAYER_COIN], 127, -1, -1);
						break;
					}
				}
			}
		}
	}
	
	center_tilemap(vg_screen, vg_level->tilemap, fixtoi(vg_player.sprite.x) + 8, fixtoi(vg_player.sprite.y) + 8);
	vg_global_frame++;
	vg_level->tileset->frame_count++;
	rest(0);
}

void vg_game_render(void)
{
	int i;
	
	draw_tilemap_bg(vg_screen, vg_level->tilemap);
	
	/* projectiles */
	for(i = 0; i < VG_MAX_PROJECTILES; i++)
	{
		if(vg_projectile[i].active)
		{
			draw_ani(vg_screen, vg_projectile[i].ap, fixtoi(vg_projectile[i].x) - vg_level->tilemap->x, fixtoi(vg_projectile[i].y) - vg_level->tilemap->y, vg_projectile[i].frame);
		}
	}
	
	/* sprites */
	for(i = 0; i < VG_MAX_OBJECTS; i++)
	{
		if(vg_sprite[i].active && vg_sprite_data[vg_sprite[i].type])
		{
			if(vg_sprite[i].type == VG_SPRITE_MARIO)
			{
				if(vg_sprite[i].d1)
				{
					color_map = &vg_light_map;
					draw_lit_sprite(vg_screen, get_ani(vg_sprite_data[vg_sprite[i].type]->ap[vg_sprite[i].state], vg_sprite[i].frame), fixtoi(vg_sprite[i].x) - vg_level->tilemap->x, fixtoi(vg_sprite[i].y) - vg_level->tilemap->y, 15 + vg_sprite[i].d1);
				}
				else
				{
					rotate_sprite(vg_screen, get_ani(vg_sprite[i].sp->ap[vg_sprite[i].state], vg_sprite[i].frame), fixtoi(vg_sprite[i].x) - vg_level->tilemap->x, fixtoi(vg_sprite[i].y) - vg_level->tilemap->y, vg_sprite[i].angle);
				}
			}
			else
			{
				rotate_sprite(vg_screen, get_ani(vg_sprite[i].sp->ap[vg_sprite[i].state], vg_sprite[i].frame), fixtoi(vg_sprite[i].x) - vg_level->tilemap->x, fixtoi(vg_sprite[i].y) - vg_level->tilemap->y, vg_sprite[i].angle);
			}
		}
	}
	if(vg_player.sprite.active)
	{
		if(vg_player.warp_type != VG_CHARACTER_WARP_TYPE_NONE)
		{
			switch(vg_player.warp_type)
			{
				case VG_CHARACTER_WARP_TYPE_LEFT:
				case VG_CHARACTER_WARP_TYPE_RIGHT_OUT:
				{
					masked_blit(get_ani(vg_player.sp->ap[vg_player.sprite.state], vg_player.sprite.frame), vg_screen, vg_player.warp_time + vg_player.sprite.cmap[vg_player.sprite.state].rx, 0, fixtoi(vg_player.sprite.x)  + vg_player.sprite.cmap[vg_player.sprite.state].rx - vg_level->tilemap->x, fixtoi(vg_player.sprite.y) - vg_level->tilemap->y, vg_player.sp->ap[vg_player.sprite.state]->w - vg_player.warp_time, vg_player.sp->ap[vg_player.sprite.state]->h);
					break;
				}
				case VG_CHARACTER_WARP_TYPE_RIGHT:
				case VG_CHARACTER_WARP_TYPE_LEFT_OUT:
				{
					masked_blit(get_ani(vg_player.sp->ap[vg_player.sprite.state], vg_player.sprite.frame), vg_screen, 0, 0, fixtoi(vg_player.sprite.x) - vg_level->tilemap->x + vg_player.warp_time, fixtoi(vg_player.sprite.y) - vg_level->tilemap->y, vg_player.sp->ap[vg_player.sprite.state]->w - vg_player.warp_time - 8, vg_player.sp->ap[vg_player.sprite.state]->h);
					break;
				}
				case VG_CHARACTER_WARP_TYPE_DOWN:
				case VG_CHARACTER_WARP_TYPE_DOWN_OUT:
				{
					masked_blit(get_ani(vg_player.sp->ap[vg_player.sprite.state], vg_player.sprite.frame), vg_screen, 0, 0, fixtoi(vg_player.sprite.x) - vg_level->tilemap->x, fixtoi(vg_player.sprite.y) - vg_level->tilemap->y + vg_player.warp_time, vg_player.sp->ap[vg_player.sprite.state]->w, vg_player.sp->ap[vg_player.sprite.state]->h - vg_player.warp_time);
					break;
				}
				case VG_CHARACTER_WARP_TYPE_DOOR_IN:
				{
					color_map = &vg_light_map;
					draw_lit_sprite(vg_screen, get_ani(vg_player.sp->ap[vg_player.sprite.state], vg_player.sprite.frame), fixtoi(vg_player.sprite.x) - vg_level->tilemap->x, fixtoi(vg_player.sprite.y) - vg_level->tilemap->y, 16 - vg_player.warp_time);
					break;
				}
			}
//		draw_ani(vg_screen, vg_player.sp->ap[vg_player.sprite.state], fixtoi(vg_player.sprite.x) - vg_level->tilemap->x, fixtoi(vg_player.sprite.y) - vg_level->tilemap->y, vg_player.sprite.frame);
		}
		else if(vg_player.sprite.state == VG_CHARACTER_HIT_RIGHT || vg_player.sprite.state == VG_CHARACTER_HIT_LEFT)
		{
			color_map = &vg_light_map;
			draw_lit_sprite(vg_screen, get_ani(vg_player.sp->ap[vg_player.sprite.state], vg_player.sprite.frame), fixtoi(vg_player.sprite.x) - vg_level->tilemap->x, fixtoi(vg_player.sprite.y) - vg_level->tilemap->y, 32 - vg_player.sprite.timer);
		}
		else if(vg_player.sprite.d1)
		{
			color_map = &vg_color_map;
			draw_trans_sprite(vg_screen, get_ani(vg_player.sp->ap[vg_player.sprite.state], vg_player.sprite.frame), fixtoi(vg_player.sprite.x) - vg_level->tilemap->x, fixtoi(vg_player.sprite.y) - vg_level->tilemap->y);
		}
		else
		{
			draw_ani(vg_screen, vg_player.sp->ap[vg_player.sprite.state], fixtoi(vg_player.sprite.x) - vg_level->tilemap->x, fixtoi(vg_player.sprite.y) - vg_level->tilemap->y, vg_player.sprite.frame);
		}
	}
	draw_tilemap_fg(vg_screen, vg_level->tilemap);

	select_palette(vg_palette);
	textprintf_ex(vg_screen, font, 33, 9, makecol(0, 0, 0), -1, "Rest %d", vg_player.lives);
	textprintf_ex(vg_screen, font, 32, 8, makecol(255, 255, 255), -1, "Rest %d", vg_player.lives);
	textprintf_ex(vg_screen, font, 33, 17, makecol(0, 0, 0), -1, "Health %d%%", vg_player.life);
	textprintf_ex(vg_screen, font, 32, 16, makecol(255, 255, 255), -1, "Health %d%%", vg_player.life);
	textprintf_centre_ex(vg_screen, font, 161, 9, makecol(0, 0, 0), -1, "%d", vg_player.score);
	textprintf_centre_ex(vg_screen, font, 160, 8, makecol(255, 255, 255), -1, "%d", vg_player.score);
}

void vg_game_draw(void)
{
	int i, j;

	acquire_bitmap(screen);
	release_bitmap(screen);
}
