#ifndef DATA_H
#define DATA_H

#include <allegro.h>
#include "modules/ncds.h"
#include "message.h"
#include "level.h"
#include "title.h"
#include "objects.h"
#include "game.h"
#include "logo.h"
#include "character.h"
#include "control.h"
#include "warp.h"
#include "projectile.h"
#include "sprite.h"

#define VG_MAX_ANIMATIONS  256
#define VG_ANIMATION_PSHOT   0
#define VG_ANIMATION_MSHOT   1

#define VG_MAX_SOUNDS        256
#define VG_SOUND_PLAYER_JUMP   0
#define VG_SOUND_PLAYER_KILL   1
#define VG_SOUND_PLAYER_WARP   2
#define VG_SOUND_PLAYER_BULLET 3
#define VG_SOUND_PLAYER_DIE    4
#define VG_SOUND_PLAYER_SHOOT  5
#define VG_SOUND_PLAYER_COIN   6

#define VG_MAX_IMAGES      256
#define VG_IMAGE_TITLE       0
#define VG_IMAGE_LSELECT     1

#define VG_STATE_TITLE   1
#define VG_STATE_LSELECT 2
#define VG_STATE_GAME    3

extern int               vg_done;
extern ANIMATION *       vg_animation[VG_MAX_ANIMATIONS];
extern BITMAP *          vg_image[VG_MAX_IMAGES];
extern CONTROLLER        vg_controller;
extern VG_CHARACTER      vg_player;
extern VG_PROJECTILE     vg_projectile[VG_MAX_PROJECTILES];
extern VG_SPRITE_DATA *  vg_sprite_data[VG_MAX_SPRITE_DATA];
extern VG_SPRITE         vg_sprite[VG_MAX_OBJECTS];
extern BITMAP *          vg_screen;
extern PALETTE           vg_palette;
extern COLOR_MAP         vg_color_map;
extern COLOR_MAP         vg_light_map;
extern int               vg_state;
extern int               vg_quit;
extern int               vg_global_frame;
extern VG_LEVEL *        vg_level;
extern TILESET *         vg_tileset;
extern TILEMAP *         vg_tilemap;
extern SAMPLE *          vg_sound[VG_MAX_SOUNDS];

extern VG_WARP           vg_last_warp;

void read_level_data(VG_LEVEL * lp);
void vg_load_data(void);
void vg_free_data(void);

#endif
