#ifndef CONTROL_H
#define CONTROL_H

#define CONTROLLER_MAX_BUTTONS 16

#define CONTROLLER_LEFT         0
#define CONTROLLER_RIGHT        1
#define CONTROLLER_UP           2
#define CONTROLLER_DOWN         3
#define CONTROLLER_JUMP         4
#define CONTROLLER_FIRE         5
#define CONTROLLER_PAUSE        6

#define MAX_JOY_KEYS     256
#define KEY_J0_LEFT      KEY_MAX + 0
#define KEY_J0_RIGHT     KEY_MAX + 1
#define KEY_J0_UP        KEY_MAX + 2
#define KEY_J0_DOWN      KEY_MAX + 3
#define KEY_J0_B0        KEY_MAX + 4
#define KEY_J0_B1        KEY_MAX + 5
#define KEY_J0_B2        KEY_MAX + 6
#define KEY_J0_B3        KEY_MAX + 7
#define KEY_J0_B4        KEY_MAX + 8
#define KEY_J0_B5        KEY_MAX + 9
#define KEY_J0_B6        KEY_MAX + 10
#define KEY_J0_B7        KEY_MAX + 11
#define KEY_J0_B8        KEY_MAX + 12
#define KEY_J0_B9        KEY_MAX + 13
#define KEY_J0_B10       KEY_MAX + 14
#define KEY_J1_LEFT      KEY_MAX + 15
#define KEY_J1_RIGHT     KEY_MAX + 16
#define KEY_J1_UP        KEY_MAX + 17
#define KEY_J1_DOWN      KEY_MAX + 18
#define KEY_J1_B0        KEY_MAX + 19
#define KEY_J1_B1        KEY_MAX + 20
#define KEY_J1_B2        KEY_MAX + 21
#define KEY_J1_B3        KEY_MAX + 22
#define KEY_J1_B4        KEY_MAX + 23
#define KEY_J1_B5        KEY_MAX + 24
#define KEY_J1_B6        KEY_MAX + 25
#define KEY_J1_B7        KEY_MAX + 26
#define KEY_J1_B8        KEY_MAX + 27
#define KEY_J1_B9        KEY_MAX + 28
#define KEY_J1_B10       KEY_MAX + 29
#define KEY_J2_LEFT      KEY_MAX + 30
#define KEY_J2_RIGHT     KEY_MAX + 31
#define KEY_J2_UP        KEY_MAX + 32
#define KEY_J2_DOWN      KEY_MAX + 33
#define KEY_J2_B0        KEY_MAX + 34
#define KEY_J2_B1        KEY_MAX + 35
#define KEY_J2_B2        KEY_MAX + 36
#define KEY_J2_B3        KEY_MAX + 37
#define KEY_J2_B4        KEY_MAX + 38
#define KEY_J2_B5        KEY_MAX + 39
#define KEY_J2_B6        KEY_MAX + 40
#define KEY_J2_B7        KEY_MAX + 41
#define KEY_J2_B8        KEY_MAX + 42
#define KEY_J2_B9        KEY_MAX + 43
#define KEY_J2_B10       KEY_MAX + 44
#define KEY_J3_LEFT      KEY_MAX + 45
#define KEY_J3_RIGHT     KEY_MAX + 46
#define KEY_J3_UP        KEY_MAX + 47
#define KEY_J3_DOWN      KEY_MAX + 48
#define KEY_J3_B0        KEY_MAX + 49
#define KEY_J3_B1        KEY_MAX + 50
#define KEY_J3_B2        KEY_MAX + 51
#define KEY_J3_B3        KEY_MAX + 52
#define KEY_J3_B4        KEY_MAX + 53
#define KEY_J3_B5        KEY_MAX + 54
#define KEY_J3_B6        KEY_MAX + 55
#define KEY_J3_B7        KEY_MAX + 56
#define KEY_J3_B8        KEY_MAX + 57
#define KEY_J3_B9        KEY_MAX + 58
#define KEY_J3_B10       KEY_MAX + 59

typedef struct
{
	
	int key;
	int pressed;
	int held;
	int released;
	
} CONTROLLER_BUTTON;

typedef struct
{
	
	CONTROLLER_BUTTON button[CONTROLLER_MAX_BUTTONS];
    
} CONTROLLER;

extern int joy_key[MAX_JOY_KEYS];

int cant_wait(void);
int get_key_all(void);
int get_joy_all(int jn);

void clear_keys(void);
void read_joy_keys(void);
void controller_read(CONTROLLER * cp);

#endif
