#include <allegro.h>
#include "modules/joy.h"
#include "control.h"

int joy_key[MAX_JOY_KEYS];
int data_left_key[4] = {KEY_LEFT, KEY_A, KEY_G, KEY_L};
int data_right_key[4] = {KEY_RIGHT, KEY_D, KEY_J, KEY_QUOTE};
int data_up_key[4] = {KEY_UP, KEY_W, KEY_Y, KEY_P};
int data_down_key[4] = {KEY_DOWN, KEY_S, KEY_H, KEY_COLON};
int data_fire_key[4] = {KEY_ENTER, KEY_1, KEY_5, KEY_9};
int data_jump_key[4] = {KEY_RSHIFT, KEY_Q, KEY_T, KEY_O};
int data_option_key[4] = {KEY_BACKSLASH, KEY_X, KEY_N, KEY_SLASH};
int data_select_key[4] = {KEY_BACKSPACE, KEY_Z, KEY_B, KEY_STOP};
int data_left_joy[4] = {KEY_J0_LEFT, KEY_J1_LEFT, KEY_J2_LEFT, KEY_J3_LEFT};
int data_right_joy[4] = {KEY_J0_RIGHT, KEY_J1_RIGHT, KEY_J2_RIGHT, KEY_J3_RIGHT};
int data_up_joy[4] = {KEY_J0_UP, KEY_J1_UP, KEY_J2_UP, KEY_J3_UP};
int data_down_joy[4] = {KEY_J0_DOWN, KEY_J1_DOWN, KEY_J2_DOWN, KEY_J3_DOWN};
int data_fire_joy[4] = {KEY_J0_B0, KEY_J1_B0, KEY_J2_B0, KEY_J3_B0};
int data_jump_joy[4] = {KEY_J0_B1, KEY_J1_B1, KEY_J2_B1, KEY_J3_B1};
int data_option_joy[4] = {KEY_J0_B2, KEY_J1_B2, KEY_J2_B2, KEY_J3_B2};
int data_select_joy[4] = {KEY_J0_B3, KEY_J1_B3, KEY_J2_B3, KEY_J3_B3};

int cant_wait(void)
{
	int ret = 0;
	int i;

	if(key[KEY_ENTER] || key[KEY_ESC] || key[KEY_SPACE])
	{
		ret = 1;
		key[KEY_ENTER] = 0;
		key[KEY_SPACE] = 0;
		key[KEY_ESC] = 0;
	}
	for(i = 0; i < num_joysticks; i++)
	{
		if(ncd_joy_button(i, 0))
		{
			ret = 1;
		}
	}

	return ret;
}

void clear_keys(void)
{
	int i;

	for(i = 0; i < KEY_MAX; i++)
	{
		key[i] = 0;
	}
	ncd_joy_poll();
}

void read_joy_keys(void)
{
	int i;

	/* read the keyboard first */
	for(i = 0; i < KEY_MAX; i++)
	{
		joy_key[i] = key[i];
	}

	/* read first joystick */
	if(ncd_joy_left(0))
	{
		joy_key[KEY_J0_LEFT]++;
	}
	else
	{
		joy_key[KEY_J0_LEFT] = 0;
	}
	if(ncd_joy_right(0))
	{
		joy_key[KEY_J0_RIGHT]++;
	}
	else
	{
		joy_key[KEY_J0_RIGHT] = 0;
	}
	if(ncd_joy_up(0))
	{
		joy_key[KEY_J0_UP]++;
	}
	else
	{
		joy_key[KEY_J0_UP] = 0;
	}
	if(ncd_joy_down(0))
	{
		joy_key[KEY_J0_DOWN]++;
	}
	else
	{
		joy_key[KEY_J0_DOWN] = 0;
	}
	for(i = 0; i < 10; i++)
	{
		if(ncd_joy_button(0, i))
		{
			joy_key[KEY_J0_B0 + i]++;
		}
		else
		{
			joy_key[KEY_J0_B0 + i] = 0;
		}
	}

	/* read second joystick */
	if(ncd_joy_left(1))
	{
		joy_key[KEY_J1_LEFT]++;
	}
	else
	{
		joy_key[KEY_J1_LEFT] = 0;
	}
	if(ncd_joy_right(1))
	{
		joy_key[KEY_J1_RIGHT]++;
	}
	else
	{
		joy_key[KEY_J1_RIGHT] = 0;
	}
	if(ncd_joy_up(1))
	{
		joy_key[KEY_J1_UP]++;
	}
	else
	{
		joy_key[KEY_J1_UP] = 0;
	}
	if(ncd_joy_down(1))
	{
		joy_key[KEY_J1_DOWN]++;
	}
	else
	{
		joy_key[KEY_J1_DOWN] = 0;
	}
	for(i = 0; i < 10; i++)
	{
		if(ncd_joy_button(1, i))
		{
			joy_key[KEY_J1_B0 + i]++;
		}
		else
		{
			joy_key[KEY_J1_B0 + i] = 0;
		}
	}

	/* read third joystick */
	if(ncd_joy_left(2))
	{
		joy_key[KEY_J2_LEFT]++;
	}
	else
	{
		joy_key[KEY_J2_LEFT] = 0;
	}
	if(ncd_joy_right(2))
	{
		joy_key[KEY_J2_RIGHT]++;
	}
	else
	{
		joy_key[KEY_J2_RIGHT] = 0;
	}
	if(ncd_joy_up(2))
	{
		joy_key[KEY_J2_UP]++;
	}
	else
	{
		joy_key[KEY_J2_UP] = 0;
	}
	if(ncd_joy_down(2))
	{
		joy_key[KEY_J2_DOWN]++;
	}
	else
	{
		joy_key[KEY_J2_DOWN] = 0;
	}
	for(i = 0; i < 10; i++)
	{
		if(ncd_joy_button(2, i))
		{
			joy_key[KEY_J2_B0 + i]++;
		}
		else
		{
			joy_key[KEY_J2_B0 + i] = 0;
		}
	}

	/* read first joystick */
	if(ncd_joy_left(3))
	{
		joy_key[KEY_J3_LEFT]++;
	}
	else
	{
		joy_key[KEY_J3_LEFT] = 0;
	}
	if(ncd_joy_right(3))
	{
		joy_key[KEY_J3_RIGHT]++;
	}
	else
	{
		joy_key[KEY_J3_RIGHT] = 0;
	}
	if(ncd_joy_up(3))
	{
		joy_key[KEY_J3_UP]++;
	}
	else
	{
		joy_key[KEY_J3_UP] = 0;
	}
	if(ncd_joy_down(3))
	{
		joy_key[KEY_J3_DOWN]++;
	}
	else
	{
		joy_key[KEY_J3_DOWN] = 0;
	}
	for(i = 0; i < 10; i++)
	{
		if(ncd_joy_button(3, i))
		{
			joy_key[KEY_J3_B0 + i]++;
		}
		else
		{
			joy_key[KEY_J3_B0 + i] = 0;
		}
	}
}

/* scan the key array for a pressed key (so all keys can be used) */
int get_key_all(void)
{
	int i, j;

	clear_keys();
	for(i = 0; i < KEY_MAX; i++)
	{
		joy_key[i] = 0;
	}
	while(1)
	{
		ncd_joy_poll();
		read_joy_keys();
		for(i = 0; i < MAX_JOY_KEYS; i++)
		{
			if((joy_key[i] && i < KEY_MAX) || joy_key[i] == 1)
			{
//				read_controller(&pp_player[0].controller);
				clear_keys();
				return i;
			}
		}
		ncds_update_music();
	}
}

/* need to scan the keyboard too (for 2 button joys) */
int get_joy_all(int jn)
{
	int i;


	while(!key[KEY_ESC])
	{
		ncd_joy_poll();
		for(i = 0; i < joy[jn].num_buttons; i++)
		{
			if(ncd_joy_button(jn, i))
			{
				return i;
			}
		}
	}
	return -1;
}

void controller_read(CONTROLLER * cp)
{
	int i;
	
	ncd_joy_poll();
	read_joy_keys();
	for(i = 0; i < CONTROLLER_MAX_BUTTONS; i++)
	{
		if(joy_key[cp->button[i].key])
		{
			cp->button[i].held++;
			if(cp->button[i].held == 1)
			{
				cp->button[i].pressed = 1;
			}
			else
			{
				cp->button[i].pressed = 0;
			}
		}
		else
		{
			if(cp->button[i].held)
			{
				cp->button[i].released = 1;
				cp->button[i].pressed = 0;
			}
			else
			{
				cp->button[i].released = 0;
			}
			cp->button[i].held = 0;
			cp->button[i].pressed = 0;
		}
	}
}
