#ifndef VG_CHARACTER_H
#define VG_CHARACTER_H

#include "modules/animate.h"
#include "modules/collide.h"
#include "sprite.h"
#include "warp.h"

#define VG_CHARACTER_MAX_STATES  32
#define VG_CHARACTER_STAND_RIGHT  0
#define VG_CHARACTER_STAND_LEFT   1
#define VG_CHARACTER_WALK_RIGHT   2
#define VG_CHARACTER_WALK_LEFT    3
#define VG_CHARACTER_JUMP_RIGHT   4
#define VG_CHARACTER_JUMP_LEFT    5
#define VG_CHARACTER_FALL_RIGHT   6
#define VG_CHARACTER_FALL_LEFT    7
#define VG_CHARACTER_DUCK_RIGHT   8
#define VG_CHARACTER_DUCK_LEFT    9
#define VG_CHARACTER_SLIDE_RIGHT 10
#define VG_CHARACTER_SLIDE_LEFT  11
#define VG_CHARACTER_GRIP_RIGHT  12
#define VG_CHARACTER_GRIP_LEFT   13
#define VG_CHARACTER_HIT_RIGHT   14
#define VG_CHARACTER_HIT_LEFT    15

#define VG_CHARACTER_JUMP_VELOCITY      -6
#define VG_CHARACTER_GRAVITY           0.29
#define VG_CHARACTER_MAX_FALL_VELOCITY   5
#define VG_CHARACTER_MAX_WALK_SPEED    2.5
#define VG_CHARACTER_WALK_ACCELERATION 0.2
#define VG_CHARACTER_JUMP_ACCELERATION 0.1
#define VG_CHARACTER_WALK_FRICTION     0.4

#define VG_CHARACTER_WARP_TYPE_NONE      0
#define VG_CHARACTER_WARP_TYPE_UP        1
#define VG_CHARACTER_WARP_TYPE_DOWN      2
#define VG_CHARACTER_WARP_TYPE_LEFT      3
#define VG_CHARACTER_WARP_TYPE_RIGHT     4
#define VG_CHARACTER_WARP_TYPE_UP_OUT    5
#define VG_CHARACTER_WARP_TYPE_DOWN_OUT  6
#define VG_CHARACTER_WARP_TYPE_LEFT_OUT  7
#define VG_CHARACTER_WARP_TYPE_RIGHT_OUT 8
#define VG_CHARACTER_WARP_TYPE_DOOR_IN   9
#define VG_CHARACTER_WARP_TYPE_DOOR_OUT 10

#define VG_CHARACTER_POWERS 8

typedef struct
{
	
	VG_SPRITE_DATA * sp;
	VG_SPRITE sprite;
	
	int score;
	int lives;
	int life;
	int warp_time, warp_type;
	VG_WARP * warp;
	
	int power[VG_CHARACTER_POWERS];
	int selected_power;
	
} VG_CHARACTER;

int vg_character_take_hit(VG_CHARACTER * cp, int points);
void vg_character_logic(VG_CHARACTER * cp);

#endif
