/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#include "ustring.h"

#include "debug.h"
#include "utils.h"
#include "plugin.h" /* To get the requested encoding */

#include <allegro.h>


const UString &EmptyString()
{
  static const UString usEmptyString("");
  return usEmptyString;
}


const UString &SpaceString()
{
  static const UString usSpaceString(" ");
  return usSpaceString;
}


const UString &NewLineString()
{
  static const UString usNewLineString("\n");
  return usNewLineString;
}


int UString::init_is_done = 0;

void UString::InitEncoding(int encoding)
{
  if(!init_is_done) {
#ifdef USE_UNICODE
    int encoding = plugin_encoding();
    LOG(
      "Encoding %c%c%c%c\n",
      (encoding>>24), (encoding>>16)&0xff, (encoding>>8)&0xff, (encoding)&0xff
    );
    set_uformat(encoding);
#endif /* USE_UNICODE */
    init_is_done = 1;
  }
}


int UString::GetEncoding(void)
{
  return get_uformat();
}


static char *convert(const char *src_str, int utype)
{
  char *ret = 0;

#ifdef USE_UNICODE
  int usize = uconvert_size(src_str, utype, U_CURRENT);
  ret = (char*) malloc(usize);
  DBG_ASSERT(ret);
  do_uconvert(src_str, utype, ret, U_CURRENT, usize);
#else /* !USE_UNICODE */
  ret = ustrdup(src_str);
  DBG_ASSERT(ret);
#endif /* !USE_UNICODE */

  return ret;
}


UString::UString(const char *src_str, int utype)
{
  UString::InitEncoding();

  ustring_ = convert(src_str, utype);
}


const char *UString::string(void) const
{
  return ustring_;
}

