/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#ifndef EME__TOOLS_DIALOG__
#define EME__TOOLS_DIALOG__
/*----------------------------------------------------------------------------
  Dialog for tools box
----------------------------------------------------------------------------*/

#include "debug.h"

#include "dialog.h"

typedef enum {
  TOOL_DRAW_POINT = 0,
  TOOL_FILL,
  TOOL_SELECT_POINT,
  TOOL_SELECT_RECT,
  TOOL_SELECT_CIRCLE,
  TOOL_SELECT_BY_PROP,
  TOOL_SELECT_BY_WAND,
  TOOL_ZOOM,
  TOOL_PASTE,
  TOOL_PASTE_BRUSH,
  TOOL_MOVE,
  TOOL_USER,
  NUM_TOOLS
} TOOL;

#define DEFAULT_TOOL TOOL_DRAW_POINT


typedef enum {
  TOOLS_DIALOG_BOX = 0,
  FIRST_TOOLS_DIALOG,
  LAST_TOOLS_DIALOG=FIRST_TOOLS_DIALOG+NUM_TOOLS-1,
  TOOLS_DIALOG_FILL_SLIDER,
  NUM_TOOLS_DIALOGS
} TOOLS_DIALOG;


#define TOOLS_GROUP 0

class SelectedTiles;
class Command;
class SparseTiles;
class Brush;
struct BITMAP;

typedef Command *(*COMMAND_CREATOR_FUNC)(int user_tool_index, int x, int y);

class ToolsDialog: public Dialog {

public:
  ToolsDialog(int x, int y, int w, int h, DIALOG *d);
  ToolsDialog(DIALOG *d);
  ~ToolsDialog(void);

  void LazyInit(void);

  void Press(int tile_x, int tile_y, int shifts);
  void Release(int tile_x, int tile_y, int shifts);
  void Click(int tile_x, int tile_y, int shifts);

  void Clear(void);
  void ClearBrush(void);
  void Copy(void);
  void CopyBrush(void);
  void Cut(void);
  /* Paste the clipboard, at mouse_x, mouse_y */
  void Paste(void);
  void PasteBrush(void);
  /* Paste 'tiles', at 0, 0 */
  void Paste(SparseTiles *tiles);

  void ChangeTool(int new_tool);
  void SetBrush(const Brush *brush);
  Brush *GetBrush(void)
    {return brush_;}

  void UpdateSelection(SelectedTiles *sel, int shifts); //Public or private?

  const char *HelpText() const;

  void Allow(bool yesno, unsigned int features);

protected:
  void Init(DIALOG *d); /* Eager init */
  void SizeInit(void); /* Lazy init */
  void TranslationInit(void); /* Lazy init */

private:
  ToolsDialog(const ToolsDialog&);
  ToolsDialog &operator=(const ToolsDialog&);

  DIALOG *box_;
  DIALOG *tools_;
  DIALOG *slider_;

  int count_; /* Increased at each click, so the commands are not merged if
                 they don't come from the same click */
  bool mouse_is_pressed_; /* Are we during a click */

  int saved_x_, saved_y_;

  SparseTiles *clipboard_;
  Brush *brush_;
};

#endif /* EME__TOOLS_DIALOG__ */

