/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#include "tiledlg.h"

#include "debug.h"
#include "utils.h"
#include "translat.h"

#include "help.h"
#include "map.h"
#include "globals.h"
#include "gui.h"
#include "entry.h"
#include "selected.h"
#include "cmdapply.h"
#include "commands.h"

#include <altheme.h>

#include <allegro.h>

#include "creator.h"

static int tiles_box_proc(int msg, DIALOG *d, int c)
{
  msg = do_help(msg, "Tiles");
  return altheme_box_proc(msg, d, c);
}


int TileDialog::ApplyProc(int msg, DIALOG *d, int c)
{
  if(msg==MSG_IDLE) return D_O_K;

  msg = do_help(msg, "Tiles");

  if(msg == MSG_CLICK || msg == MSG_KEY) {
    altheme_button_proc(msg, d, c);
    if(d->flags & D_SELECTED) {
      GUI.Apply();
      d->flags &= ~D_SELECTED;
      scare_mouse_area(d->x, d->y, d->w, d->h);
      altheme_button_proc(MSG_DRAW, d, 0);
      unscare_mouse();
    }
    return D_O_K;
  }
  return altheme_button_proc(msg, d, c);
}


TileDialog::TileDialog(int x, int y, int w, int h, DIALOG *d):
  Dialog(x, y, w, h, d)
{
  Init(d);
}

TileDialog::TileDialog(DIALOG *d): Dialog(d)
{
  Init(d);
}

TileDialog::~TileDialog(void)
{
  delete tile_entry;
}

void TileDialog::Init(DIALOG *d)
{
  box = &(d[TILE_DIALOG_BOX]);
  box->proc = tiles_box_proc;

  apply = &(d[TILE_DIALOG_APPLY]);
  apply->proc = ApplyProc;

  /* Entry should be the last one, because we don't want to know how many
     DIALOGs it uses */
  entry = &(d[TILE_DIALOG_ENTRY]);
  tile_entry = new Entry(entry, "Tiles");
  CHECK_POINTER(tile_entry);
}

void TileDialog::InitMap(void)
{
  if(!GetMap()) {
    tile_entry->SetDefaultState();
  }
}

void TileDialog::LazyInit(void)
{
  static const Translation i18nApply("Apply");

  apply->dp = i18nApply.void_ptr();

  apply->x = box->x + DIALOG_PADDING;
  apply->y = box->y+box->h - DIALOG_PADDING - SINGLE_HEIGHT;
  apply->w = box->w - 2*DIALOG_PADDING;
  apply->h = SINGLE_HEIGHT;

  tile_entry->SetSize(
    box->x + DIALOG_PADDING,
    box->y + DIALOG_PADDING,
    box->w - 2*DIALOG_PADDING,
    box->h - apply->h - 3*DIALOG_PADDING
  );
}


Entry *TileDialog::GetEntry(void) const
{
  return tile_entry;
}


const char *TileDialog::HelpText() const
{
  static const Translation i18nTile("Tile value chooser");
  static const Translation i18nApply("Apply to all selected tiles");

  int mx = mouse_x;
  int my = mouse_y;
  if (mx>=apply->x && mx<apply->x+apply->w && my>=apply->y && my<apply->y+apply->h) {
    return i18nApply;
  }
  return i18nTile;
}


void TileDialog::Allow(bool yesno, unsigned int features)
{
  if (features&Features::TileBox::Apply) {
    if (yesno) apply->flags &= ~D_DISABLED;
    else apply->flags |= D_DISABLED;
  }
}
