/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#ifndef EME__SIZE__
#define EME__SIZE__

/*
 * Size and position of a rectangle
 */
class Size {
public:
  static const int undefined = -1;

  Size(int x, int y, int w=0, int h=0):
    begini_(x), beginj_(y), endi_(x+w), endj_(y+h) {}
  Size():
    begini_(undefined), beginj_(undefined), endi_(undefined), endj_(undefined) {}
  Size(const Size &other):
    begini_(other.begini_), beginj_(other.beginj_), endi_(other.endi_), endj_(other.endj_) {}
  ~Size() {}

  Size &operator=(const Size &other) {
    begini_=other.begini_; beginj_=other.beginj_;
    endi_=other.endi_; endj_=other.endj_;
    return *this;
  }

  int begini() const { return begini_; }
  int beginj() const { return beginj_; }
  int endi() const { return endi_; }
  int endj() const { return endj_; }
  int width() const { return endi()-begini(); }
  int height() const { return endj()-beginj(); }

  bool is_in(int i, int j) const
    { return i>=begini() && i<endi() && j>=beginj() && j<endj(); }

  void update(int i, int j) {
    if (begini_==undefined || i<begini_) begini_ = i;
    if (beginj_==undefined || j<beginj_) beginj_ = j;
    if (endi_==undefined || i+1>endi_) endi_ = i+1;
    if (endj_==undefined || j+1>endj_) endj_ = j+1;
  }

  void update(const Size &other) {
    if (other.width()!=0 && other.height()!=0) {
      update(other.begini(), other.beginj());
      update(other.endi()-1, other.endj()-1);
    }
  }

private:
  int begini_, beginj_;
  int endi_, endj_;
};

#endif /* EME__SIZE__ */

