/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#ifndef EME__LAYER_VIEWED__
#define EME__LAYER_VIEWED__

#include "utils.h"

class ViewedLayers {
  ViewedLayers &operator=(const ViewedLayers&);

  int count_;
  char *layers_; // could have a bool* impl ?

  static char *create_layers(int count) {
    char *ptr;
    Calloc(ptr, count);
    return ptr;
  }
  static char *insert_layer(char *layers, int count, int where) {
    char *new_layers = layers;
    if (Realloc(new_layers, count+1)) {
      for (int n=count; n>where; --n) {
        new_layers[n] = new_layers[n-1];
      }
      return new_layers;
    }
    return 0;
  }
  static char *remove_layer(char *layers, int count, int where) {
    for (int n=where+1; n<count; ++n) {
      layers[n-1] = layers[n];
    }
    return layers;
  }

public:
  /* All layers to true */
  ViewedLayers(int count):
    count_(count), layers_(create_layers(count)) {
    for (int l=0; l<count_; ++l) layers_[l] = true;
  }

  /* All layers to 'layers' value */
  ViewedLayers(int count, const char *layers):
    count_(count), layers_(create_layers(count)) {
    for (int l=0; l<count_; ++l) layers_[l] = layers[l];
  }

  /* Layer 'l' to true, all others to false */
  ViewedLayers(int count, int l):
    count_(count), layers_(create_layers(count)) {
    layers_[l] = true;
  }

  /* Copy constructor */
  ViewedLayers(const ViewedLayers &other):
    count_(other.count_), layers_(create_layers(count_)) {
    for (int l=0; l<count_; ++l) layers_[l] = other.at(l);
  }

  ~ViewedLayers() { Free(layers_); }

  bool at(int l) const { return layers_[l]; }
  int count() const { return count_; }

  char *get() { return layers_; }
  void set(int l) { layers_[l] = 1; }
  void reset(int l) { layers_[l] = 0; }

  void insert(int l) {
    char *new_layers = insert_layer(layers_, count_, l);
    if (new_layers) {
      layers_ = new_layers;
      count_++;
    }
  }
  void remove(int l) {
    char *new_layers = remove_layer(layers_, count_, l);
    if (new_layers) {
      layers_ = new_layers;
      count_--;
    }
  }
};

#endif /* EME__LAYER_VIEWED__ */
