/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#include "dialog.h"

#include "debug.h"
#include "utils.h"

#include <allegro.h>


Dialog::Dialog(
  int x, int y,            /* Dialog position on the screen (in pixels) */
  int w, int h,            /* Dialog size (in pixels) */
  DIALOG *d                /* Array of dialogs */
): map_(0), dialog_(d)
{
  d->x = x;
  d->y = y;
  d->w = w;
  d->h = h;
}


Dialog::Dialog(
  DIALOG *d                /* Array of dialogs */
): map_(0), dialog_(d)
{
  d->x = 0;
  d->y = 0;
  d->w = 1;
  d->h = 1;
}


Dialog::~Dialog(void)
{
}


void Dialog::SetSize(int x, int y, int w, int h, DIALOG *d)
{
  if (!d) d=dialog_;
  d->x=x;
  d->y=y;
  d->w=w;
  d->h=h;
  LazyInit();
}


void Dialog::LazyInit(void)
{
}


void Dialog::InitMap(void)
{
}


Map *Dialog::GetMap(void) const /* Returns the map worked on */
{
  return map_;
}


void Dialog::SetMap( /* Sets the map to work on */
  Map *m                   /* Map to work on */
) 
{
  map_=m;
  InitMap();
}


const char *Dialog::Help(int mx, int my) const
{
  if (mx>=dialog_->x && mx<dialog_->x+dialog_->w && my>=dialog_->y && my<dialog_->y+dialog_->h) {
    return HelpText();
  }
  return 0;
}


const char *Dialog::HelpText() const
{
  return 0;
}

