/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#include "creator.h"

#include "debug.h"
#include "utils.h"
#include "ustring.h"
#include "translat.h"

#include <typeinfo>

#include "prop.h"
#include "prop.h"
#include "entry.h"


/* Constructor/destructor
   ---------------------------------*/
BaseCreator::BaseCreator(StaticString *name, BaseProperty *p):
  reference_(p), name_(name)
{
  DBG_SET_CREATOR_TYPE("BaseCreator");
  name_->Hold();
}


BaseCreator::BaseCreator(const BaseCreator *other):
  reference_(other->reference_->Clone()), name_(other->name_)
{
  DBG_SET_CREATOR_TYPE("BaseCreator");
  CHECK_POINTER(reference_);
  name_->Hold();
}


BaseCreator::~BaseCreator(void)
{
  delete reference_;
  name_->Release();
}


StaticString *BaseCreator::GetName(void) const
{
  return name_;
}


/* Properties
   ---------------------------------*/
BaseProperty *BaseCreator::Create(void) const
{
  LOG("BaseCreator::Create\n");
  return reference_->Clone();
}


int BaseCreator::IsSameType(const BaseProperty *p) const
{
  /* Note that typeid(*reference_) can be different from Property,
     since it is possible to derive from Creator
   */
  return typeid(*reference_)==typeid(*p);
}


void BaseCreator::Draw(
  const BaseProperty *p, BITMAP *bmp, int x, int y, int w, int h, float scale,
  int l, int i, int j
) const
{
}

int BaseCreator::PrintValue(
  const BaseProperty * /*p*/, BITMAP *bmp, int x, int y, int color
) const
{
  textprintf(
    bmp, font, x, y, color, Translation("%s: ???"), GetName()->string()
  );
  return 1;
}


/* Entry Handlers
   ---------------------------------*/
void BaseCreator::UpdateEntry(Entry *e) const
{
  UpdateEntry(e, reference_);
}


void BaseCreator::UpdateReferenceProperty(const Entry *e) const
{
  UpdateProperty(reference_, e);
}


void BaseCreator::UpdateReferenceProperty(const BaseProperty &p) const
{
  DBG_ASSERT(IsSameType(&p));
  reference_->CopyFrom(&p);
}

