/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#include "cnumber.h"

#include "debug.h"
#include "utils.h"
#include "ustring.h"
#include "translat.h"

#include "entry.h"

#include "ustring.h"
#include "alclean.h"

#include <altheme.h>

#include <allegro.h>


#define MAX_CHARS STRING_INT_LENGTH



/* Misc
   ---------------------------------*/
void Number::Draw(int value, BITMAP *bmp, int x, int y, int w, int h)
{
  static UString usFormat("%d");
  text_mode(gui_bg_color);
  textprintf_centre(bmp, font, x+w/2, y+2, gui_fg_color, usFormat, value);
}



/* Property
   ---------------------------------*/
#if 0
Number::Property::~Property(void)
{
}


void Number::Property::CopyFrom(const BaseProperty *p)
{
  const Property *pn = ::Cast<Number>(p);
  value_ = pn->value_;
}


int Number::Property::IsEqualTo(const BaseProperty *p) const
{
  const Property *pn = ::Cast<Number>(p);
  return pn->value_ == value_;
}


Number::Property *Number::Property::Clone(void) const
{
  return new Property(Get());
}
#endif


/* Creator
   ---------------------------------*/
Number::Creator::Creator(StaticString *name, int v):
  BaseCreator(name, new Property(v))
{
  DBG_SET_CREATOR_TYPE("Number");
  Init(EmptyString());
}


Number::Creator::Creator(StaticString *name, Property *ref):
  BaseCreator(name, ref)
{
  DBG_SET_CREATOR_TYPE("Number");
  Init(EmptyString());
}


void Number::Creator::Init(const char *str)
{
  Malloc(str_, (MAX_CHARS+1)*SIZEOF_CHARACTER);
  ustrzcpy(str_, MAX_CHARS*SIZEOF_CHARACTER, str);
}


Number::Creator *Number::Creator::Clone(void) const
{
  return new Creator(this);
}


Number::Creator::~Creator(void)
{
  Free(str_);
}


void Number::Creator::Draw(
  const BaseProperty *p, BITMAP *bmp, int x, int y, int w, int h,
  float scale, int l, int i, int j
) const
{
  DBG_ASSERT(IsSameType(p));
  const Property *pn = ::Cast<Number>(p);
  Number::Draw(pn->Get(), bmp, x, y, w, h);
}


int Number::Creator::PrintValue(
  const BaseProperty *p, BITMAP *bmp, int x, int y, int color
) const
{
  DBG_ASSERT(IsSameType(p));
  const Property *pn = ::Cast<Number>(p);
  textprintf(
    bmp, font, x, y, color, Translation("%s: Number %d"),
    GetName()->string(), pn->Get()
  );
  return 1;
}


void Number::Creator::UpdateEntry(Entry *e, const BaseProperty *p) const
{
  DBG_ASSERT(IsSameType(p));
  const Property *pn = ::Cast<Number>(p);
  uszprintf(str_, MAX_CHARS, UString("%d"), pn->Get());
  e->SetState(
    GetName()->string(), altheme_edit_proc, MAX_CHARS, ustrlen(str_), str_,
    NULL, NULL, 0
  );
}


void Number::Creator::UpdateProperty(BaseProperty *p, const Entry *e) const
{
  DBG_ASSERT(IsSameType(p));
  Property *pn = ::Cast<Number>(p);
  const char *str_value = CAST_FROM_VOID_PTR(const char*, e->GetDPState());
  pn->Set(uatoi(str_value));
}

