/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#ifndef EME__COMMAND_SELECTION__
#define EME__COMMAND_SELECTION__
/*----------------------------------------------------------------------------
  Selections commands:

- Adding tiles to the selection
- Removing tiles from the selection
- Replacing the selection by a new one
----------------------------------------------------------------------------*/

#include "debug.h"

#include "command.h"

class SelectedTiles;
class Map;

/* Adding tiles to the selection
   ----------------------*/
class CommandSelectionAdd: public Command {

public:
  CommandSelectionAdd(Map *map, const SelectedTiles *sel);
  virtual ~CommandSelectionAdd(void);

  void UnExecute(void);
  void Execute(void);

  int IsEmpty(void) const;

protected:

private:
  CommandSelectionAdd(const CommandSelectionAdd&);
  CommandSelectionAdd &operator=(const CommandSelectionAdd&);

  SelectedTiles *to_edit;
  SelectedTiles *to_add; /* Tiles added to the selection */
};


/* Removing tiles from the selection
   ----------------------*/
class CommandSelectionSuppress: public Command {

public:
  CommandSelectionSuppress(Map *map, const SelectedTiles *sel);
  virtual ~CommandSelectionSuppress(void);

  void UnExecute(void);
  void Execute(void);

  int IsEmpty(void) const;

protected:

private:
  CommandSelectionSuppress(const CommandSelectionSuppress&);
  CommandSelectionSuppress &operator=(const CommandSelectionSuppress&);

  SelectedTiles *to_edit;
  SelectedTiles *to_suppress; /* Tiles removed from the selection */
};


/* Replacing the selection by a new one
   ----------------------*/
class CommandSelectionReplace: public Command {

public:
  CommandSelectionReplace(Map *map, const SelectedTiles *sel);
  virtual ~CommandSelectionReplace(void);

  void UnExecute(void);
  void Execute(void);

  int IsEmpty(void) const;

protected:

private:
  CommandSelectionReplace(const CommandSelectionReplace&);
  CommandSelectionReplace &operator=(const CommandSelectionReplace&);

  SelectedTiles *to_edit;
  SelectedTiles *new_selection; /* Tiles in the new selection */
  SelectedTiles *old_selection; /* Tiles in the previous selection */
};

#endif /* EME__COMMAND_SELECTION__ */

