/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#include "cmdpaste.h"

#include "debug.h"
#include "utils.h"

#include "selected.h"
#include "tiles.h"
#include "stiles.h"
#include "lutils.h"
#include "map.h"

#include "creator.h"


CommandPaste::CommandPaste(
  Map *map, int l, const SparseTiles *to_paste, int x, int y
): Command()
{
  tiles = to_paste->clone();
  CHECK_POINTER(tiles);

  layer = map->GetLayer(l);

  /* Area where the tiles will be pasted */
  int x1 = x;
  int x2 = x+tiles->width();
  int y1 = y;
  int y2 = y+tiles->height();
  SelectedTiles *square = new SelectedTiles();
  CHECK_POINTER(square);
  for(int i=x1; i<=x2; i++) for(int j=y1; j<=y2; j++) {
    square->Add(i, j);
  }

  /* Save the tiles that exists and will be modified */
  saved_tiles = LayerUtils::Copy(layer, square);
  CHECK_POINTER(saved_tiles);

  /* Save the places where there is currently no tile, but there will be */
  saved_empty_tiles = LayerUtils::SelectEmpty(layer, square);
  CHECK_POINTER(saved_empty_tiles);

  delete square;

  this->x = x;
  this->y = y;
}


CommandPaste::~CommandPaste(void)
{
  delete saved_tiles;
  delete saved_empty_tiles;
  delete tiles;
}


void CommandPaste::Execute(void)
{
  LOG("CommandPaste::Execute\n");
  LayerUtils::Paste(layer, x, y, tiles);
}


void CommandPaste::UnExecute(void)
{
  LayerUtils::Paste(layer, x, y, saved_tiles);
  if (!saved_empty_tiles->Empty()) LayerUtils::Cut(layer, saved_empty_tiles);
}


int CommandPaste::IsEmpty(void) const
{
  return tiles->count()==0;
}

