/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#ifndef EME__GROUP_COMMAND__
#define EME__GROUP_COMMAND__
/*----------------------------------------------------------------------------
  Group of commands

  Allows to execute and unexecute several commands that will be handled
  by the manager as if they were atomic
----------------------------------------------------------------------------*/


#include "command.h"

#include "debug.h"

class CommandGroup: public Command {

public:
  /* Constructor/Destructor
     ---------------------------------*/
  CommandGroup(void);
  virtual ~CommandGroup(void);

  /* Execution
     ---------------------------------*/
  /* Executes the command
   */
  virtual void UnExecute(void);

  /* Un-executes the command
   */
  virtual void Execute(void);

  /* Merge 'cmd' with itself, returns true if has succeded
   */
  virtual int Merge(Command * /*cmd*/)
    {return 0;}

  /* Returns true (1) if would do nothing in Execute and UnExecute,
     else false (0)
   */
  virtual int IsEmpty(void) const;

  /* Adding commands
     ---------------------------------*/
  void Add(Command *cmd);

protected:

private:
  CommandGroup(const CommandGroup&);
  CommandGroup &operator=(const CommandGroup&);

  int commands_count;
  Command **commands;
  bool first_time;
};

#endif /* EME__GROUP_COMMAND__ */

