/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#include "cbool.h"

#include "debug.h"
#include "utils.h"
#include "ustring.h"
#include "translat.h"

#include "cstring.h" /* For drawing */

#include "entry.h"

#include <altheme.h>

#include <allegro.h>

#define MAX_CHARS 16



/* Misc
   ---------------------------------*/
void Boolean::Draw(
  bool yesno, BITMAP *bmp, int x, int y, int w, int h
)
{
  static const Translation i18nOn("On");
  static const Translation i18nOff("Off");

  text_mode(gui_bg_color);
  if (yesno) {
    String::Draw(i18nOn, bmp, x, y, w, h);
  }
  else {
    String::Draw(i18nOff, bmp, x, y, w, h);
  }
}



/* Property
   ---------------------------------*/
Boolean::Property::~Property(void)
{
}


void Boolean::Property::CopyFrom(const BaseProperty *p)
{
  Set(::Cast<Boolean>(p)->Get());
}


int Boolean::Property::IsEqualTo(const BaseProperty *p) const
{
  return Get() == ::Cast<Boolean>(p)->Get();
}


Boolean::Property *Boolean::Property::Clone(void) const
{
  return new Property(Get());
}



/* Creator
   ---------------------------------*/
Boolean::Creator::Creator(StaticString *name, int yesno):
  BaseCreator(name, new Property(yesno))
{
  DBG_SET_CREATOR_TYPE("Boolean");
}


Boolean::Creator::~Creator(void)
{
}


Boolean::Creator *Boolean::Creator::Clone(void) const
{
  return new Creator(this);
}


void Boolean::Creator::Draw(
  const BaseProperty *p, BITMAP *bmp, int x, int y, int w, int h,
  float scale, int l, int i, int j
) const
{
  DBG_ASSERT(p);
  DBG_ASSERT(IsSameType(p));
  const Property *pb = ::Cast<Boolean>(p);
  Boolean::Draw(pb->Get(), bmp, x, y, w, h);
}


int Boolean::Creator::PrintValue(
  const BaseProperty *p, BITMAP *bmp, int x, int y, int color
) const
{
  DBG_ASSERT(p);
  DBG_ASSERT(IsSameType(p));
  const Property *pb = ::Cast<Boolean>(p);
  if(pb->Get()) {
    textprintf(
      bmp, font, x, y, color,
      Translation("%s: Boolean true"), GetName()->string()
    );
  }
  else {
    textprintf(
      bmp, font, x, y, color,
      Translation("%s: Boolean false"), GetName()->string()
    );
  }
  return 1;
}


void Boolean::Creator::UpdateEntry(Entry *e, const BaseProperty *p) const
{
  DBG_ASSERT(IsSameType(p));
  const Property *pb = ::Cast<Boolean>(p);
  e->SetState(
    GetName()->string(),
    altheme_button_proc, 0, 0, CAST_TO_VOID_PTR(GetName()->string()),
    NULL, NULL, pb->Get() ? D_SELECTED : 0
  );
}


void Boolean::Creator::UpdateProperty(BaseProperty *p, const Entry *e) const
{
  DBG_ASSERT(IsSameType(p));
  Property *pb = ::Cast<Boolean>(p);
  if(e->GetFlagsState() & D_SELECTED) {
    pb->Set();
  }
  else {
    pb->Reset();
  }
}

