/* seme - a simple map editor based on eme
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#include "semeprop.h"

#include "semefile.h"

#include "debug.h"
#include "utils.h"
#include "ustring.h"
#include "alclean.h"

#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <allegro.h>

#define NO_NAME "<no name>"

/* Constructor/destructor
   ---------------------------------*/
SemeProperty::SemeProperty(void):
  name(new StaticString(UString(NO_NAME))),
  title(0)
{
  CHECK_POINTER(name);
  name->Hold();
}


SemeProperty::~SemeProperty(void)
{
  name->Release();
  if(title) free(title);
}


void SemeProperty::CopyFrom(const SemeProperty *p)
{
  if(name) name->Release();
  name = p->name;
  name->Hold();
  SubCopyFrom(p);
}


/* Property name
   ---------------------------------*/
void SemeProperty::SetName(const char *str)
{
  char *tmpstr = CleanForSeme(str);

  if(name) name->Release();
  name = new StaticString(tmpstr);
  name->Hold();

  free(tmpstr);
}


StaticString *SemeProperty::GetName(void) const
{
  return name;
}


const char *SemeProperty::GetAsciiName(void) const
{
  static char *ascii_name = 0;
  if (ascii_name) free(ascii_name);
  ascii_name = uconvert_dup(name->string(), U_CURRENT, U_ASCII);
  return ascii_name;
}


/* Property additional data
   ---------------------------------*/
int SemeProperty::AskAdditionalData(void)
{
  return 1;
}


const char *SemeProperty::GetDataDescription(void)
{
  return EmptyString();
}


/* Internal function
   ---------------------------------*/
const char *SemeProperty::CreateTitle(
  const char *beginning, const char *ending
)
{
  if(title) free(title);
  title = (char*)malloc(
    ustrsizez(beginning)+ustrsizez(GetName()->string())+ustrsizez(ending)
  );
  if(!title) {
    ERROR_NOMEM();
    return 0;
  }
  ustrcpy(title, beginning);
  ustrcat(title, GetName()->string());
  ustrcat(title, ending);
  return title;
}


const char *SemeProperty::PrintDataDesc(const char *format, ...)
{
  va_list ap;

  va_start(ap, format);
  uvszprintf(data_desc, DATA_DESC_LEN, format, ap);
  va_end(ap);

  return data_desc;
}

