/* seme - a simple map editor based on eme
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#include "semenbr.h"

#include "semeprop.h"
#include "semefile.h"
#include "semevrsn.h"

#include "debug.h"
#include "utils.h"
#include "ustring.h"

#include <altheme.h>

#include <allegro.h>

#include "cnumber.h"
typedef Number::Creator NumberCreator;
typedef Number::Property NumberProperty;


static const UString &usNumber()
{
  static const UString str("Number");
  return str;
}
SEME_REGISTER(SemeNumber, usNumber(), SemeNumber::Create);


/* Constructor/destructor
   ---------------------------------*/
SemeProperty *SemeNumber::Create(void)
{
  SemeProperty *ret = new SemeNumber();
  CHECK_POINTER(ret);
  return ret;
}


SemeNumber::SemeNumber(void): SemeProperty()
{
}


SemeNumber::~SemeNumber(void)
{
}


void SemeNumber::SubCopyFrom(const SemeProperty * /*p*/)
{
}


/* Additional data -- none
   ---------------------------------*/


/* Loading/saving format file
   ---------------------------------*/
int SemeNumber::SaveFormat(FILE * /*f*/, int /*num_indent*/) const
{
  return 1;
}


int SemeNumber::LoadFormat(FILE * /*f*/, int /*num_indent*/)
{
  return 1;
}


/* Creating/loading/saving map
   ---------------------------------*/
BaseCreator *SemeNumber::CreateCreator(void)
{
  BaseCreator *ret = new NumberCreator(GetName(), SEME_DEFAULT_NUMBER);
  return ret;
}


BaseCreator *SemeNumber::LoadProperty(PACKFILE *pf, int version)
{
  int val = pack_mgetl(pf);
  NumberCreator *creator=new NumberCreator(GetName(), val);
  return creator;
}


BaseProperty *SemeNumber::LoadTile(
  PACKFILE *pf, int version, const BaseCreator *creator
) const
{
  const NumberCreator *nc = Cast<Number>(creator);
  int val = pack_mgetl(pf);
  return nc->Create(val);
}


int SemeNumber::Save(PACKFILE *pf, int version, const BaseProperty *p) const
{
  const NumberProperty *pn = Cast<Number>(p);
  return pack_mputl(pn->Get(), pf) != EOF;
}


/* Saving C code
   ---------------------------------*/
int SemeNumber::SaveCStructField(FILE *f, int num_indent) const
{
  char *str = CleanForC(GetName()->string());
  if(!str) {
    return 0;
  }
  Print(
    f, num_indent, "int %s; /* %s */", str,
    SemePropertyManager::GetAsciiName(GetType())
  );
  free(str);
  return 1;
}


int SemeNumber::SaveCCode(
  FILE *f, int num_indent, const char *leading, const char * /*cleaning*/
) const
{
  char *str = CleanForC(GetName()->string());
  if(!str) {
    return 0;
  }
  Print(f, num_indent, "%s%s = pack_mgetl(file);", leading, str);
  free(str);
  return 1;
}


int SemeNumber::SaveCCleanCode(
  FILE * /*f*/, int /*num_indent*/, const char * /*leading*/
) const
{
  return 1;
}

