/* seme - a simple map editor based on eme
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#ifndef SEME__FILE__UTILS__
#define SEME__FILE__UTILS__
/*------------------------------------------------------------------------------
  File I/O for seme

- Define for seme map format file
- Writing seme map format file
- Reading seme map format file
- Functions for C code file
------------------------------------------------------------------------------*/

#include "debug.h"


#include <stdio.h> /* For FILE */

/* Define for seme map format file
   ---------------------------------*/
#define SEME_INDENT '\t'
#define SEME_COMMENT '#'

#define SEME_YES_STR "yes"
#define SEME_NO_STR  "no"

#define SEME_COMPRESS_STR           "compress"
#define SEME_COMPRESS_YES_STR          SEME_YES_STR
#define SEME_COMPRESS_NO_STR           SEME_NO_STR
#define SEME_MAP_STR                "map"
#define SEME_MAP_SHAPE_RECT_STR        "rectangle"
#define SEME_MAP_SHAPE_DIAMOND_STR     "diamond"
#define SEME_TILE_STR               "tile"
#define SEME_TILE_SHAPE_RECT_STR       "rectangle"
#define SEME_TILE_SHAPE_DIAMOND_STR    "diamond"
#define SEME_TILE_SIZE_STR             "size"
#define SEME_TILE_ODDNESS_STR          "oddness"
#define SEME_ODD_NONE_STR                 "none"
#define SEME_ODD_RIGHT_STR                "right"
#define SEME_ODD_LEFT_STR                 "left"
#define SEME_TILE_OFFSET_STR           "offset"
#define SEME_MAP_PROPERTIES_STR     "map_properties"
#define SEME_FULL_LAYERS_STR        "full_layers"

#define SEME_STRCMP(s1,s2) (stricmp(s1, s2) == 0)


/* Helper
   ---------------------------------*/
/* File and return value are U_ASCII. Returns a newly allocated string */
char *my_fgets(FILE *stream);


/* Writing seme map format file
   File and params are U_ASCII
   ---------------------------------*/
void NewLine(FILE *f);
void Indent(FILE *f, int num_indent);
void Comment(FILE *f, const char *fmt, ...);
void Field(
  FILE *f, int num_indent, const char *field_name, const char *field_fmt, ...
);


/* Reading seme map format file
   File and return values are U_ASCII
   ---------------------------------*/
/* Returns a newly allocated string, eats indents and comments */
char *ReadLine(FILE *f, int num_indent);
char *ReadField(FILE *f, int num_indent, const char *field_name);

/* Cleaning string
   input and output are U_CURRENT
   ---------------------------------*/
char *CleanForSeme(const char *name);


/* Functions for C code file
   File, params and return value are U_ASCII
   ---------------------------------*/
int Print(FILE *f, int num_indent, const char *fmt, ...);

/* Parameter is U_CURRENT, return value is ascii */
char *CleanForC(const char *name);



/* Relative pathes
   All pathes (in allegro.cfg and in format files) are relative to the
   executable directory
   ---------------------------------*/
/* Input and output are U_ASCII */
/* Returns a newly allocated string */
char *relativize(const char *path);
/* Returns a newly allocated string */
char *derelativize(const char *path);

/* Input and output are U_CURRENT */
/* Returns a newly allocated string */
char *urelativize(const char *path);
/* Returns a newly allocated string */
char *uderelativize(const char *path);


#endif /* SEME__FILE__UTILS__ */

