/* seme - a simple map editor based on eme
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#ifndef SEME__DIALOG__
#define SEME__DIALOG__

struct DIALOG;

#define IS_IN(d, mx, my) \
  ((mx)>=(d)->x && (mx)<(d)->x+(d)->w && (my)>=(d)->y && (my)<(d)->y+(d)->h)

#include "help.h"
#define HANDLE_HELP(msg, d, c) \
  do { \
    if ((msg)==MSG_RPRESS) { \
      while(mouse_b) {} \
      if (d->dp3 && (msg)==MSG_RPRESS) { \
        while(mouse_b) { } \
        /*popup_text(Translation("Help"), (char*)(d)->dp3);*/ \
        popup_help((char*)(d)->dp3); \
      } \
      return D_O_K; \
    } \
  } while(0)


int seme_button_proc(int msg, DIALOG *d, int c);
int seme_text_proc(int msg, DIALOG *d, int c);
int seme_radio_proc(int msg, DIALOG *d, int c);
int seme_check_proc(int msg, DIALOG *d, int c);
int seme_edit_proc(int msg, DIALOG *d, int c);
int seme_list_proc(int msg, DIALOG *d, int c);
int seme_proplist_proc(int msg, DIALOG *d, int c);

void dialog(DIALOG &d, int x, int y, int w, int h);
void dialog(DIALOG &d, int x, int y, int w, int h, const char *help);
void dialog(DIALOG &d, int x, int y, int w, int h, const char *help, void *dp, int (*proc)(int, DIALOG*, int));
void end(DIALOG &d);
void box(DIALOG &d, int x, int y, int w, int h);
void title(DIALOG &d, int x, int y, int w, int h, const char *str);
void text(DIALOG &d, int x, int y, int w, int h, const char *help, const char *str);
void radio(DIALOG &d, int x, int y, int w, int h, const char *help, int group, int flags, const char *str);
void edit(DIALOG &d, int x, int y, int w, int h, const char *help, char *str, int len);
void check(DIALOG &d, int x, int y, int w, int h, const char *help, int flags);
void button(DIALOG &d, int x, int y, int w, int h, int key, int flags, const char *str);
void proplist(DIALOG &d, int x, int y, int w, int h, const char *help);
void databutton(DIALOG &d, int x, int y, int w, int h, const char *help, const char *str);
void datatext(DIALOG &d, int x, int y, int w, int h, const char *help);

#endif /* SEME__DIALOG__ */

