/* seme - a simple map editor based on eme
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#include "semecol.h"

#include "semeprop.h"
#include "semefile.h"
#include "semevrsn.h"

#include "debug.h"
#include "utils.h"
#include "ustring.h"

#include <altheme.h>

#include <allegro.h>

#include "ccolor.h"
typedef Color::Creator ColorCreator;
typedef Color::Property ColorProperty;


static const UString &usColor()
{
  static const UString str("Color");
  return str;
}
SEME_REGISTER(SemeColor, usColor(), SemeColor::Create);


/* Constructor/destructor
   ---------------------------------*/
SemeProperty *SemeColor::Create(void)
{
  SemeProperty *ret = new SemeColor();
  CHECK_POINTER(ret);
  return ret;
}


SemeColor::SemeColor(void): SemeProperty()
{
}


SemeColor::~SemeColor(void)
{
}


void SemeColor::SubCopyFrom(const SemeProperty * /*p*/)
{
}


/* Additional data -- none
   ---------------------------------*/


/* Loading/saving format file
   ---------------------------------*/
int SemeColor::SaveFormat(FILE * /*f*/, int /*num_indent*/) const
{
  return 1;
}


int SemeColor::LoadFormat(FILE * /*f*/, int /*num_indent*/)
{
  return 1;
}


/* Creating/loading/saving map
   ---------------------------------*/
BaseCreator *SemeColor::CreateCreator(void)
{
  BaseCreator *ret = new ColorCreator(GetName(), SEME_DEFAULT_COLOR);
  return ret;
}


BaseCreator *SemeColor::LoadProperty(PACKFILE *pf, int version)
{
  int red = pack_getc(pf);
  int green = pack_getc(pf);
  int blue = pack_getc(pf);
  ColorCreator *creator=new ColorCreator(GetName(), red, green, blue);
  return creator;
}


BaseProperty *SemeColor::LoadTile(
  PACKFILE *pf, int version, const BaseCreator *creator
) const
{
  const ColorCreator *cc = Cast<Color>(creator);
  int red = pack_getc(pf);
  int green = pack_getc(pf);
  int blue = pack_getc(pf);
  return cc->Create(red, green, blue);
}


int SemeColor::Save(PACKFILE *pf, int version, const BaseProperty *p) const
{
  const ColorProperty *pc = Cast<Color>(p);
  if (pack_putc(pc->GetRed(), pf) == EOF) return 0;
  if (pack_putc(pc->GetGreen(), pf) == EOF) return 0;
  if (pack_putc(pc->GetBlue(), pf) == EOF) return 0;
  return 1;
}


/* Saving C code
   ---------------------------------*/
int SemeColor::SaveCStructField(FILE *f, int num_indent) const
{
  char *str = CleanForC(GetName()->string());
  if(!str) {
    return 0;
  }
  Print(
    f, num_indent, "int %s; /* %s */", str,
    SemePropertyManager::GetAsciiName(GetType())
  );
  free(str);
  return 1;
}


int SemeColor::SaveCCode(
  FILE *f, int num_indent, const char *leading, const char * /*cleaning*/
) const
{
  char *str = CleanForC(GetName()->string());
  if(!str) {
    return 0;
  }
  Print(f, num_indent, "{");
  Print(f, num_indent+1, "int red = pack_getc(file);");
  Print(f, num_indent+1, "int green = pack_getc(file);");
  Print(f, num_indent+1, "int blue = pack_getc(file);");
  Print(f, num_indent+1, "%s%s = makecol(red, green, blue);", leading, str);
  Print(f, num_indent, "}");
  free(str);
  return 1;
}


int SemeColor::SaveCCleanCode(
  FILE * /*f*/, int /*num_indent*/, const char * /*leading*/
) const
{
  return 1;
}

