#include "loader.h"

#include <stdlib.h>
#include <allegro.h>



static void loader_cleanup(PACKFILE *f, LOADER_MAP *map)
{
   loader_destroy_map(map);
   if(f) {
      pack_fclose(f);
   }
}



static int loader_test_file(PACKFILE *file, LOADER_MAP *map)
{
   if(pack_ferror(file) || pack_feof(file)) {
      loader_cleanup(file, map);
      return 0;
   }
   return 1;
}



LOADER_MAP *loader_load_map(LOADER_SEME_CONST char *fname)
{
   LOADER_MAP *map = NULL;
   PACKFILE *file = NULL;
   int majik, version;
   int i, j;

   /* Open the file */
   file = pack_fopen(fname, "rp");
   if (!file) {
      loader_cleanup(file, map);
      return NULL;
   }

   /* Load the majik number and seme version */
   majik = pack_mgetl(file);
   if(majik != LOADER_SEME_MAJIK) {
      loader_cleanup(file, map);
      return NULL;
   }
   version = pack_mgetl(file);
   if(!loader_test_file(file, map)) return NULL;

   /* Create the map structure */
   map = (LOADER_MAP*) malloc(sizeof(LOADER_MAP));
   if (!map) {
      return NULL;
   }

   /* Load the map size */
   map->width = pack_mgetl(file);
   map->height = pack_mgetl(file);
   if(!loader_test_file(file, map)) return NULL;

   /* Create the tile array */
   map->tiles = (LOADER_TILE**) malloc(sizeof(LOADER_TILE) * map->width);
   if (!map->tiles) {
      loader_cleanup(file, map);
      return NULL;
   }
   for (i=0; i<map->width; i++) {
      map->tiles[i] = (LOADER_TILE*) malloc(sizeof(LOADER_TILE) * map->height);
      if (!map->tiles[i]) {
         loader_cleanup(file, map);
         return NULL;
      }
   }

   /* Load the map properties */
   {
      int len = pack_mgetl(file);
      map->Name = (char*) malloc(sizeof(char)*len);
      if(!map->Name) {
         loader_cleanup(file, map);
         return NULL;
      }
      pack_fread(map->Name, len, file);
   }
   if(!loader_test_file(file, map)) return NULL;

   /* Load the tiles */
   if (version<LOADER_SEME_WITH_FORTRAN_LOOP) {
      /* Old version */
      for (i=0; i<map->width; i++) {
         for (j=0; j<map->height; j++) {
            /* Can't do the test after, because it will always be false the last time */
            if(!loader_test_file(file, map)) return NULL;
            map->tiles[i][j].Ground = pack_mgetl(file);
            map->tiles[i][j].Bottom_left = pack_mgetl(file);
            map->tiles[i][j].Bottom_right = pack_mgetl(file);
            map->tiles[i][j].Top_left = pack_mgetl(file);
            map->tiles[i][j].Top_right = pack_mgetl(file);
         }
      }
   }
   else {
      /* New version */
      for (j=0; j<map->height; j++) {
         for (i=0; i<map->width; i++) {
            /* Can't do the test after, because it will always be false the last time */
            if(!loader_test_file(file, map)) return NULL;
            map->tiles[i][j].Ground = pack_mgetl(file);
            map->tiles[i][j].Bottom_left = pack_mgetl(file);
            map->tiles[i][j].Bottom_right = pack_mgetl(file);
            map->tiles[i][j].Top_left = pack_mgetl(file);
            map->tiles[i][j].Top_right = pack_mgetl(file);
         }
      }
   }

   /* Every thing went OK */
   pack_fclose(file);

   return map;
}



void loader_destroy_map(LOADER_MAP *map)
{
   int i, j;

   if(map) {
      /* Clean the map properties */
      free(map->Name);

      if(map->tiles) {
         /* Clean the tiles */
         for (i=0; i<map->width; i++) {
            if(map->tiles[i]) {
               for (j=0; j<map->height; j++) {
               }
               free(map->tiles[i]);
            }
         }
         free(map->tiles);
      }
      free(map);
   }
}


