/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#ifndef EME__USTRING__
#define EME__USTRING__
/*----------------------------------------------------------------------------
  Class for handling strings that must be converted to U_CURRENT
----------------------------------------------------------------------------*/


#include <allegro.h>

#include "debug.h"

typedef char ENCODED_CHAR;


class UString {
public:
  static void InitEncoding(int encoding=U_ASCII);
  static int GetEncoding(void);

  explicit UString(const char *src_str, int utype=U_ASCII);

  inline ~UString(void)
    { free(ustring_); }

  inline operator const char *(void) const
    { return string(); }

  const char *string(void) const;

private:
  static int init_is_done;

  /* Forbid default functions created by the compiler */
  UString(const UString&);
  UString& operator=(const UString&);

  char *ustring_;
};

const UString &EmptyString();
const UString &SpaceString();
const UString &NewLineString();


#endif /* EME__USTRING__ */

