/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#include "tstack.h"


TilesStack::TilesStack():
  layers_(), size_()
{
}


TilesStack::TilesStack(const TilesStack &other):
  layers_(other.depth()), size_(other.size_)
{
  for (int n=0; n<other.depth(); ++n) {
    const Tiles *t = other.get(n);
    if (t) set(n, t->clone());
    else set(n, 0);
  }
}


TilesStack::~TilesStack()
{
}


void TilesStack::set(int l, Tiles *t)
{
  if (is_in(l)) {
    layers_[l] = t;
    update();
  }
  else {
    insert(l, t);
  }
}


void TilesStack::clear(int l)
{
  if (is_in(l)) {
    layers_[l] = 0;
    update();
  }
}


void TilesStack::remove(int l)
{
  Imp tmp;
  for (int n=0; n<l; ++n) {
    tmp.push_back(layers_[n]);
  }
  for (int n=l+1; n<depth(); ++n) {
    tmp.push_back(layers_[n]);
  }
  clear(l);
  std::swap(layers_, tmp);
}


void TilesStack::insert(int l, Tiles *t)
{
  if (l==end()) {
    layers_.push_back(t);
  }
  else if (is_in(l)) {
    Imp::iterator it = layers_.begin();
    advance(it, l-begin());
    layers_.insert(it, t);
  }
  else {
    for (int n=depth(); n!=l; ++n) {
      layers_.push_back(0);
    }
    layers_.push_back(t);
  }
  update();
}


void TilesStack::update()
{
  Size tmp;
  for (int l=begin(); l<end(); ++l) {
    if (get(l)) {
      tmp.update(get(l)->size());
    }
  }
  std::swap(size_, tmp);
}

