/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#ifndef EME__TRANSLATION__
#define EME__TRANSLATION__
/*----------------------------------------------------------------------------
  Class for handling strings that must be translated
----------------------------------------------------------------------------*/


class Translation {

public:
  explicit Translation(const char *source);
  ~Translation(void);

  inline operator const char *(void) const
    {return string();}

  const char *string(void) const;

  /* These are ugly, but Allegro asks too much for void* and char* */
  char *char_ptr(void) const
    { return const_cast<char*>(string()); }
  void *void_ptr(void) const
    { return static_cast<void*>(char_ptr()); }

private:
  /* Forbid default functions created by the compiler */
  Translation(const Translation&);
  Translation& operator=(const Translation&);

  const char *source_;
  mutable const char *translation_;
};

#endif /* EME__TRANSLATION__ */

