/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#include "translat.h"

#include "debug.h"
#include "ustring.h"

#include <allegro/internal/aintern.h>


Translation::Translation(const char *src): source_(src), translation_(0)
{
}


Translation::~Translation(void)
{
}


const char *Translation::string(void) const
{
  if(!translation_ && _allegro_count>0) {
    translation_ = (char*)get_config_text(source_);
  }
  if (translation_) return translation_;
  /* The global EmptyString may not be already initialized */
  else return EMPTY_STRING;
}

