/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#ifndef EME__TILE_DIALOG__
#define EME__TILE_DIALOG__
/*----------------------------------------------------------------------------
  Dialog for modifying tiles properties
----------------------------------------------------------------------------*/

#include "debug.h"

#include "dialog.h"
#include "entry.h" /* for NUM_ENTRY_DIALOGS */

typedef enum {
  TILE_DIALOG_BOX = 0,
  TILE_DIALOG_APPLY,
  TILE_DIALOG_ENTRY,
  NUM_TILE_DIALOGS = TILE_DIALOG_ENTRY+NUM_ENTRY_DIALOGS
} TILE_DIALOG;

class Entry;

class TileDialog: public Dialog {

public:
  TileDialog(int x, int y, int w, int h, DIALOG *d);
  TileDialog(DIALOG *d);
  ~TileDialog(void);

  void InitMap(void);

  void LazyInit(void);

  Entry *GetEntry(void) const;

  void Allow(bool yesno, unsigned int features);

protected:
  void Init(DIALOG *d);

  const char *HelpText() const;

private:
  TileDialog(const TileDialog&);
  TileDialog &operator=(const TileDialog&);

  DIALOG *box;
  DIALOG *apply;
  DIALOG *entry;
  Entry *tile_entry;

  static int ApplyProc(int msg, DIALOG *d, int c);
};

#endif /* EME__TILE_DIALOG__ */

