/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#ifndef EME__TEMPLATE__
#define EME__TEMPLATE__
/*----------------------------------------------------------------------------
  Template Property

----------------------------------------------------------------------------*/

#include "debug.h"
#include "utils.h"

#include "prop.h"



template <typename Type>
typename Type::Property *Cast(BaseProperty *p)
{
  return DYNAMIC_CAST(typename Type::Property*, p);
}
template <typename Type>
const typename Type::Property *Cast(const BaseProperty *p)
{
  return DYNAMIC_CAST(const typename Type::Property*, p);
}
template <typename Type>
typename Type::Creator *Cast(BaseCreator *p)
{
  return DYNAMIC_CAST(typename Type::Creator*, p);
}
template <typename Type>
const typename Type::Creator *Cast(const BaseCreator *p)
{
  return DYNAMIC_CAST(const typename Type::Creator*, p);
}


template <typename Base> class TemplateProperty: public BaseProperty {
  static inline const TemplateProperty *cast(const BaseProperty *p)
    { return DYNAMIC_CAST(const TemplateProperty*, p); }
public:
  TemplateProperty(Base value):
    BaseProperty(), value_(value) {}
  ~TemplateProperty() {}

  const Base &Get() const { return value_; }
  void Set(const Base &value) { value_ = value; }

  BaseProperty *Clone() const
    { return new TemplateProperty(Get()); }
  void CopyFrom(const BaseProperty *p)
    { Set(cast(p)->Get()); }
  int IsEqualTo(const BaseProperty *p) const
    { return Get()==cast(p)->Get(); }
private:
  Base value_;
};

template <typename Base, typename Param> class TemplateProperty2: public BaseProperty {
  static inline const TemplateProperty2 *cast(const BaseProperty *p)
    { return DYNAMIC_CAST(const TemplateProperty2*, p); }
public:
  TemplateProperty2(Param param, Base value):
    BaseProperty(), param_(param), value_(value) {}
  ~TemplateProperty2() {}

  const Base &Get() const { return value_; }
  void Set(Base value) { value_ = value; }

  const Param &GetParam() const { return param_; }
  void SetParam(const Param &param) { param_ = param; }

  BaseProperty *Clone() const
    { return new TemplateProperty2(GetParam(), Get()); }
  void CopyFrom(const BaseProperty *p)
    { SetParam(cast(p)->GetParam()); Set(cast(p)->Get()); }
  int IsEqualTo(const BaseProperty *p) const
    { return GetParam()==cast(p)->GetParam() && Get()==cast(p)->Get(); }
private:
  Param param_;
  Base value_;
};


#endif /* EME__TEMPLATE__ */

