/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#ifndef EME__PLUGIN__
#define EME__PLUGIN__
/*----------------------------------------------------------------------------
  The functions to be written by the user
----------------------------------------------------------------------------*/


#include "debug.h"

#define LS_NO_ERROR      0 /* Every thing is OK */
#define LS_ERROR_UNKNOWN 1 /* Other types of errors */
#define LS_ERROR_MEM     2 /* Unable to allocate memory */
#define LS_ERROR_FILE    3 /* Unable to open file, file not found, etc. */
#define LS_ERROR_READ    4 /* Unable to read file, file too short, etc. */
#define LS_ERROR_WRITE   5 /* Unable to write file */
#define LS_ERROR_OPTION  6 /* Unknown option */
#define LS_ERROR_INVALID 7 /* Invalid input */

#define LS_ERROR_UNKNOWN_STR "unknown error"
#define LS_ERROR_MEM_STR     "out of memory"
#define LS_ERROR_FILE_STR    "error in file"
#define LS_ERROR_READ_STR    "error reading file"
#define LS_ERROR_WRITE_STR   "error writing file"
#define LS_ERROR_OPTION_STR  "unknown option"
#define LS_ERROR_INVALID_STR "invalid input"

extern const char *get_error_string(int err);

class Map;

/* Must return U_ASCII, U_UTF8 or U_UNICODE */
int plugin_encoding(void);

/* Must return an ascii string */
const char *plugin_help(void);

/* Must reurn a U_CURRENT string */
const char *plugin_about(void);

int plugin_init(int argc, const char **argv);
void plugin_exit(void);

int plugin_new(void);
int plugin_load(const char *fname);
int plugin_save(const char *fname, const Map *map);

#endif /* EME__PLUGIN__ */

