/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#include "mouse.h"

#include "debug.h"

#include <allegro.h>


#define DEFAULT_MOUSE_SPRITE_W 16
#define DEFAULT_MOUSE_SPRITE_H 16

static char mouse_busy_data[DEFAULT_MOUSE_SPRITE_W][DEFAULT_MOUSE_SPRITE_H] = {
  {0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0},
  {0,0,0,0,1,1,2,2,2,2,1,1,0,0,0,0},
  {0,0,0,1,2,2,1,1,2,1,2,2,1,0,0,0},
  {0,0,1,2,1,1,0,1,2,1,1,1,2,1,0,0},
  {0,1,2,1,0,0,0,1,2,1,0,1,1,2,1,0},
  {0,1,2,1,0,0,0,1,2,1,1,2,1,2,1,0},
  {1,2,1,0,0,0,0,1,2,1,2,1,0,1,2,1},
  {1,2,1,0,0,0,0,1,2,2,1,0,0,1,2,1},
  {1,2,1,0,0,0,0,1,2,1,0,0,0,1,2,1},
  {1,2,1,0,0,0,0,0,1,0,0,0,0,1,2,1},
  {0,1,2,1,0,0,0,0,0,0,0,0,1,2,1,0},
  {0,1,2,1,0,0,0,0,0,0,0,0,1,2,1,0},
  {0,0,1,2,1,1,0,0,0,0,1,1,2,1,0,0},
  {0,0,0,1,2,2,1,1,1,1,2,2,1,0,0,0},
  {0,0,0,0,1,1,2,2,2,2,1,1,0,0,0,0},
  {0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0}
};

BITMAP *mouse_busy_sprite = 0; // destroy it

BITMAP *get_mouse_busy_sprite(void)
{
  if(!mouse_busy_sprite) {
    int i, j;

    mouse_busy_sprite = create_bitmap(
      DEFAULT_MOUSE_SPRITE_W, DEFAULT_MOUSE_SPRITE_H
    );
    for(i=0; i<DEFAULT_MOUSE_SPRITE_W; i++) {
      for(j=0; j<DEFAULT_MOUSE_SPRITE_H; j++) {
        int col;
        if(bitmap_color_depth(mouse_busy_sprite) == 8) {
          switch(mouse_busy_data[i][j]) {
            case 1: col = 16; break;
            case 2: col = 255; break;
            default: col = 0; break;
          }
        }
        else {
          switch(mouse_busy_data[i][j]) {
            case 1: col = makecol(255, 255, 255); break;
            case 2: col = makecol(0, 0, 0); break;
            default: col = mouse_busy_sprite->vtable->mask_color; break;
          }
        }
        putpixel(mouse_busy_sprite, j, i, col);
      }
    }
  }
  return mouse_busy_sprite;
}


/* For when the mouse is broken */
#ifdef PARALYTIC_MOUSE

#define MOUSE_SPEED 2
static int _my_mouse_x=0;
static int _my_mouse_y=0;

static int simulate_mouse(int key)
{
  if (key_shifts&KB_SHIFT_FLAG) {
    int speed=DRUNK_SPEED;
    if (key_shifts&KB_CTRL_FLAG) speed*=8;
    if ((key>>8) == KEY_UP) {
      _my_mouse_y=MID(0,_my_mouse_y-speed,SCREEN_H-1);
      return 0;
    }
    if ((key>>8) == KEY_DOWN) {
      _my_mouse_y=MID(0,_my_mouse_y+speed,SCREEN_H-1);
      return 0;
    }
    if ((key>>8) == KEY_LEFT) {
      _my_mouse_x=MID(0,_my_mouse_x-speed,SCREEN_W-1);
      return 0;
    }
    if ((key>>8) == KEY_RIGHT) {
      _my_mouse_x=MID(0,_my_mouse_x+speed,SCREEN_W-1);
      return 0;
    }
  }
  return key;
}

#include <allegro/aintern.h>
int paralytic_do_dialog(DIALOG *dialog, int focus_obj)
{
  keyboard_callback = simulate_mouse;
   BITMAP *mouse_screen = _mouse_screen;
   int screen_count = _gfx_mode_set_count;
   DIALOG_PLAYER *player;

   if (!is_same_bitmap(_mouse_screen, screen))
      show_mouse(screen);

   player = init_dialog(dialog, focus_obj);

   while (update_dialog(player)) {
     if(_my_mouse_x!=mouse_x || _my_mouse_y!=mouse_y) {
       position_mouse(_my_mouse_x, _my_mouse_y);
     }
   }

   if (_gfx_mode_set_count == screen_count)
      show_mouse(mouse_screen);

   int ret= shutdown_dialog(player);
   keyboard_callback = 0;
   return ret;
}

#endif /* PARALYTIC_MOUSE */

