/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#include "icon.h"

#include "../icon/circle.xpm"
#include "../icon/draw.xpm"
#include "../icon/fill.xpm"
#include "../icon/move.xpm"
#include "../icon/paste.xpm"
#include "../icon/pasteb.xpm"
#include "../icon/point.xpm"
#include "../icon/prop.xpm"
#include "../icon/rect.xpm"
#include "../icon/wand.xpm"
#include "../icon/zoom.xpm"

#include "../icon/add.xpm"
#include "../icon/del.xpm"
#include "../icon/down.xpm"
#include "../icon/up.xpm"
#include "../icon/eye.xpm"
#include "../icon/noway.xpm"

#include <allegro.h>
#include <stdlib.h>
#include <stdio.h>


typedef struct {
  char c; int v;
} Color;


static Color *create_colors(int count, char *lines[], int mask, int invert)
{
  Color *ret = malloc(sizeof(Color) * (count+1));
  if (ret) {
    int n;
    for (n=0; n<count; ++n) {
      char c;
      int v;
      if (sscanf(lines[n], "%c c #%x", &c, &v) == 2) {
        int r = (v>>16)&0xff;
        int g = (v>>8)&0xff;
        int b = v&0xff;
        if (invert) {
          r = 128 + (r-128)/2;
          g = 128 + (g-128)/2;
          b = 128 + (b-128)/2;
        }
        ret[n].c = c;
        ret[n].v = makecol(r, g, b);
      }
      else if (sscanf(lines[n], "%c c None", &c) == 1) {
        ret[n].c = c;
        ret[n].v = mask;
      }
      else {
        free(ret);
        return 0;
      }
    }
    ret[count].c = 0;
  }
  return ret;
}


static int find_color(Color *colors, int c)
{
  while (colors->c) {
    if (colors->c == c) return colors->v;
    colors++;
  }
  return 0;
}


BITMAP *create_bitmap_from_xpm(char *icon[], int invert)
{
  BITMAP *ret = 0;
  int width, height, colors_count, colors_size;
  Color *colors;

  sscanf(icon[0], "%d %d %d %d", &width, &height, &colors_count, &colors_size);

  if (colors_size!=1) return 0;

  ret = create_bitmap(width, height);
  if (!ret) return 0;

  colors = create_colors(colors_count, icon+1, bitmap_mask_color(ret), invert);
  if (!colors) return 0;

  {
    int i, j;
    for (j=0; j<height; ++j) {
      char *line = icon[colors_count+1+j];
      for (i=0; i<width; ++i) {
        char c = line[i];
        putpixel(ret, i, j, find_color(colors, c));
      }
    }
  }

  free(colors);

  return ret;
}


#define GET_ICON(name) \
  BITMAP *get_##name##_icon(int enabled) \
  { \
    static BITMAP *icon_enabled = 0; \
    static BITMAP *icon_disabled = 0; \
    if (!icon_enabled) icon_enabled = create_bitmap_from_xpm(name##_xpm, 0); \
    if (!icon_disabled) icon_disabled = create_bitmap_from_xpm(name##_xpm, 1); \
    return enabled ? icon_enabled : icon_disabled; \
  }

  GET_ICON(circle)
  GET_ICON(draw)
  GET_ICON(fill)
  GET_ICON(move)
  GET_ICON(paste)
  GET_ICON(pasteb)
  GET_ICON(point)
  GET_ICON(prop)
  GET_ICON(rect)
  GET_ICON(wand)
  GET_ICON(zoom)

  GET_ICON(add)
  GET_ICON(del)
  GET_ICON(down)
  GET_ICON(up)
  GET_ICON(eye)
  GET_ICON(noway)

