/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#include "font.h"

#include <allegro.h>
#include <altheme.h>

FONT *saved_font = 0;

FONT *get_font(FONT_SIZE size)
{
  if (!saved_font) saved_font = font;
  if (size == FONT_SIZE_SMALL) {
    return small_font;
  }
  else if (size == FONT_SIZE_BIG) {
    return saved_font;
  }
  else {
    return font;
  }
}

int font_is_small(FONT *font)
{
  return font == small_font;
}

