/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#include "debug.h"

#include <altheme.h>

#include <stdlib.h>
#include <stdarg.h>
#include <stdio.h>

#include <allegro.h>
#include <allegro/internal/aintern.h>

#include "emepopup.h"

#define W 320 /* Max popup width */
#define H 200 /* Max popup height */

#define BW 80 /* OK/cancel button width */
#define DH 20 /* Text/button height */

#define SIZEOF_CHARACTER 6


/*------------------------------------------------------------------------------
  popup_quit
------------------------------------------------------------------------------*/

void popup_quit(const char *message1, const char *message2, const char *message3)
{
  if(alert(
    (char*)message1, (char*)message2, (char*)message3,
    get_config_text("Quit"), get_config_text("Continue"), 0, 0
  )==1) {
    DBG_ASSERT(0);
    exit(1);
  }
}


/*------------------------------------------------------------------------------
  popup_size
------------------------------------------------------------------------------*/
#define STRING_INT_LENGTH 32
int popup_size(
  const char *width_title, int *width, const char *height_title, int *height
)
{
  static char width_str[STRING_INT_LENGTH*SIZEOF_CHARACTER] = EMPTY_STRING;
  static char height_str[STRING_INT_LENGTH*SIZEOF_CHARACTER] = EMPTY_STRING;

  if (
    popup_edit(width_title, width_str, STRING_INT_LENGTH) == TRUE &&
    popup_edit(height_title, height_str, STRING_INT_LENGTH) == TRUE
  ) {
    *width = uatof(width_str);
    *height = uatof(height_str);
    return TRUE;
  }
  return FALSE;
}

/*------------------------------------------------------------------------------
  popup_size_and_pos
------------------------------------------------------------------------------*/
#define W 320
#define H 200
#define DW 80
#define DH 20
typedef enum {
  SIZE_AND_POS_BOX = 0,
  SIZE_AND_POS_TITLE,

  SIZE_AND_POS_X_TEXT,
  SIZE_AND_POS_X_VALUE,
  SIZE_AND_POS_Y_TEXT,
  SIZE_AND_POS_Y_VALUE,
  SIZE_AND_POS_W_TEXT,
  SIZE_AND_POS_W_VALUE,
  SIZE_AND_POS_H_TEXT,
  SIZE_AND_POS_H_VALUE,

  SIZE_AND_POS_LIST,

  SIZE_AND_POS_OK,
  SIZE_AND_POS_CANCEL,
  SIZE_AND_POS_COUNT
} SIZE_AND_POS_IDX;

static char *popup_size_and_pos_cb(int index, int *list_size, DIALOG *d)
{
  char **list = (char**)(d->dp3);
  if (index >= 0) {
    return list[index];
  }
  else {
    *list_size = 0;
    if (list) {
      for ( ; list[*list_size]; (*list_size)++) {
      }
    }
    return NULL;
  }
}

int popup_size_and_pos(
  const char *title, int *x, int *y, int *w, int *h,
  const char **list, int *item
)
{
  static char x_str[STRING_INT_LENGTH*SIZEOF_CHARACTER] = EMPTY_STRING;
  static char y_str[STRING_INT_LENGTH*SIZEOF_CHARACTER] = EMPTY_STRING;
  static char w_str[STRING_INT_LENGTH*SIZEOF_CHARACTER] = EMPTY_STRING;
  static char h_str[STRING_INT_LENGTH*SIZEOF_CHARACTER] = EMPTY_STRING;

  static DIALOG dialogs[] = {
    {altheme_shadow_box_proc, 0, 0, W, H },
    {altheme_ctext_proc, W/2, 8, W/2, DH },

    {altheme_text_proc,   8, 8+DH*1, W/4-8, DH },
    {altheme_edit_proc, W/4, 8+DH*1, W/4-8, DH,
      0, 0, 0, 0, STRING_INT_LENGTH, 0, x_str },
    {altheme_text_proc,   8, 8+DH*2, W/4-8, DH },
    {altheme_edit_proc, W/4, 8+DH*2, W/4-8, DH,
      0, 0, 0, 0, STRING_INT_LENGTH, 0, y_str },
    {altheme_text_proc,   8, 8+DH*3, W/4-8, DH },
    {altheme_edit_proc, W/4, 8+DH*3, W/4-8, DH,
      0, 0, 0, 0, STRING_INT_LENGTH, 0, w_str },
    {altheme_text_proc,   8, 8+DH*4, W/4-8, DH },
    {altheme_edit_proc, W/4, 8+DH*4, W/4-8, DH,
      0, 0, 0, 0, STRING_INT_LENGTH, 0, h_str },

    {altheme_list_proc, W/2, 8+DH*1, W/2-8, DH*4,
      0, 0, 0, 0, 0, 0, popup_size_and_pos_cb },

    {altheme_button_proc,   8, H-8-DH, 80, DH, 0, 0, '\r', D_EXIT },
    {altheme_button_proc, 232, H-8-DH, 80, DH, 0, 0,    0, D_EXIT },
    {}
  };

  dialogs[SIZE_AND_POS_TITLE].dp = (void*)title;

  dialogs[SIZE_AND_POS_X_TEXT].dp = (void*)get_config_text("X position");
  dialogs[SIZE_AND_POS_Y_TEXT].dp = (void*)get_config_text("Y position");
  dialogs[SIZE_AND_POS_W_TEXT].dp = (void*)get_config_text("Width");
  dialogs[SIZE_AND_POS_H_TEXT].dp = (void*)get_config_text("Height");
  dialogs[SIZE_AND_POS_OK].dp = (void*)get_config_text("OK");
  dialogs[SIZE_AND_POS_CANCEL].dp = (void*)get_config_text("Cancel");

  dialogs[SIZE_AND_POS_LIST].dp3 = 0;
  dialogs[SIZE_AND_POS_LIST].flags |= D_DISABLED;
  if (list && item) {
    dialogs[SIZE_AND_POS_LIST].dp3 = (void*)list;
    dialogs[SIZE_AND_POS_LIST].flags &= ~D_DISABLED;
  }

  dialogs[SIZE_AND_POS_X_VALUE].flags |= D_DISABLED;
  ustrzcpy(x_str, sizeof(x_str), EMPTY_STRING);
  dialogs[SIZE_AND_POS_Y_VALUE].flags |= D_DISABLED;
  ustrzcpy(y_str, sizeof(y_str), EMPTY_STRING);
  dialogs[SIZE_AND_POS_W_VALUE].flags |= D_DISABLED;
  ustrzcpy(w_str, sizeof(w_str), EMPTY_STRING);
  dialogs[SIZE_AND_POS_H_VALUE].flags |= D_DISABLED;
  ustrzcpy(h_str, sizeof(h_str), EMPTY_STRING);
  if (x) {
    uszprintf(x_str, sizeof(x_str), "%d", *x);
    dialogs[SIZE_AND_POS_X_VALUE].flags &= ~D_DISABLED;
  }
  if (y) {
    uszprintf(y_str, sizeof(y_str), "%d", *y);
    dialogs[SIZE_AND_POS_Y_VALUE].flags &= ~D_DISABLED;
  }
  if (w) {
    uszprintf(w_str, sizeof(w_str), "%d", *w);
    dialogs[SIZE_AND_POS_W_VALUE].flags &= ~D_DISABLED;
  }
  if (h) {
    uszprintf(h_str, sizeof(h_str), "%d", *h);
    dialogs[SIZE_AND_POS_H_VALUE].flags &= ~D_DISABLED;
  }

  set_dialog_color(dialogs, gui_fg_color, gui_bg_color);
  centre_dialog(dialogs);
  if (popup_dialog(dialogs, -1)==SIZE_AND_POS_OK) {
    if (x) *x = uatof(x_str);
    if (y) *y = uatof(y_str);
    if (w) *w = uatof(w_str);
    if (h) *h = uatof(h_str);
    if (list && item) *item = dialogs[SIZE_AND_POS_LIST].d1;
    return TRUE;
  }
  else {
    return FALSE;
  }
}

