/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#ifndef EME__FEATURES__
#define EME__FEATURES__

namespace Features {
  namespace Group {
    typedef enum {
      MapMenu,
      EditMenu,
      SelectMenu,
      BrushMenu,
      UserMenu,
      TileBox,
      LayersBox,
      ToolsBox,

      VariableLayerSize,
      VariableLayerCount,
      VariableMapSize,
      Select,
      Brushes,

      Everything
    } Groups;
  }

  namespace MapMenu {
    const unsigned int ResizeAll = 1<<0;
    const unsigned int InsertInAll = 1<<1;
    const unsigned int DeleteInAll = 1<<2;
    const unsigned int ResizeActive = 1<<3;
    const unsigned int InsertInActive = 1<<4;
    const unsigned int DeleteInActive = 1<<5;
#if 0
    const unsigned int MergeVisible = 1<<6;
#endif

    const unsigned int VariableLayerSize =
      ResizeActive | InsertInActive | DeleteInActive;
#if 0
    const unsigned int VariableLayerCount = MergeVisible;
#else
    const unsigned int VariableLayerCount = 0;
#endif
    const unsigned int VariableMapSize =
      ResizeAll | InsertInAll | DeleteInAll;
    const unsigned int Everything =
      VariableLayerSize | VariableLayerCount | VariableMapSize;
  }

  namespace EditMenu {
    const unsigned int Undo = 1<<0;
    const unsigned int Redo = 1<<1;
    const unsigned int Copy = 1<<2;
    const unsigned int CopyBrush = 1<<3;
    const unsigned int Cut = 1<<4;

    const unsigned int Brushes = CopyBrush;
    const unsigned int Everything =
      Undo | Redo | Copy | CopyBrush | Cut;
  }

  namespace SelectMenu {
    const unsigned int All = 1<<0;
    const unsigned int None = 1<<1;
    const unsigned int Invert = 1<<2;
    const unsigned int Grow = 1<<3;
    const unsigned int Shrink = 1<<4;

    const unsigned int Select =
      All | None | Invert | Grow | Shrink;
    const unsigned int Everything = Select;
  }

  namespace BrushMenu {
    const unsigned int Load = 1<<0;
    const unsigned int Save = 1<<2;
    const unsigned int Choose = 1<<3;

    const unsigned int Brushes =
      Load | Save | Choose;
    const unsigned int Everything = Brushes;
  }

  namespace UserMenu {
    const unsigned int Everything = 0;
  }

  namespace TileBox {
    const unsigned int Apply = 1<<0;

    const unsigned int Everything = Apply;
  }

  namespace LayersBox {
    const unsigned int Add = 1<<0;
    const unsigned int Del = 1<<1;
    const unsigned int Swap = 1<<2;

    const unsigned int VariableLayerCount =
      Add | Del | Swap;
    const unsigned int Everything = VariableLayerCount;
  }

  namespace ToolsBox {
    const unsigned int Pencil = 1<<0;
    const unsigned int Fill = 1<<1;
    const unsigned int Point = 1<<2;
    const unsigned int Rectangle = 1<<3;
    const unsigned int Circle = 1<<4;
    const unsigned int ByProperty = 1<<5;
    const unsigned int Wand = 1<<6;
    const unsigned int Zoom = 1<<7;
    const unsigned int Paste = 1<<8;
    const unsigned int PasteBrush = 1<<9;
    const unsigned int Move = 1<<10;
    const unsigned int User = 1<<11;

    const unsigned int VariableLayerSize = Move;
    const unsigned int Select =
      Point | Rectangle | Circle | ByProperty | Wand;
    const unsigned int Brushes = PasteBrush;
    const unsigned int Everything =
      Pencil | Fill | Select | Zoom | Paste | PasteBrush | Move | User;
  }

};

#endif /* EME__FEATURES__ */

