/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#ifndef EME__DEBUG__
#define EME__DEBUG__
/*----------------------------------------------------------------------------
  Debug helpers

  - Profile
  - Normal Debug
  - User Debug
----------------------------------------------------------------------------*/



/* Profile
   ---------------------------------*/
#ifdef PROFILE

#  include <stdio.h>
#  include <time.h>

#  define PROFILE_BEGIN(name) clock_t profile_##name##_begin = clock();

#  define PROFILE_END(name)                                         \
   clock_t profile_##name##_end = clock();                          \
   al_trace(                                                        \
     "PROFILE: %s: %8ld\n",                                 \
     #name, (long int)(profile_##name##_end-profile_##name##_begin) \
   );

#else /* !PROFILE */

#  define PROFILE_BEGIN(name) ((void)0);
#  define PROFILE_END(name) ((void)0);

#endif /* !PROFILE */


/* Normal Debug
   ---------------------------------*/
#ifdef     DEBUG

#  include <allegro.h>

#  define DBG_ASSERT(t)                                       \
  if(!(t)) al_trace(                                          \
    "Assertion failed at %s.%d: " #t "\n", __FILE__, __LINE__ \
  ), abort()

#  if defined(__GNUC__)
#    define LOG(fmt, arg...) al_trace(fmt, ## arg)
#  else
#    define LOG (void)sizeof
#  endif

#  define LOGEXEC() al_trace("%s.%d\n", __FILE__, __LINE__)

#else  /* !DEBUG */

#  define DBG_ASSERT(t) ((void)0)

#  if defined(__GNUC__)
#    define LOG(fmt, arg...) ((void)0)
#  else
#    define LOG (void)sizeof
#  endif

#  define LOGEXEC() ((void)0)

#endif /* !DEBUG */


/* User Debug
   ---------------------------------*/
#ifdef USER_DEBUG

#  define USER_ASSERT(t) DBG_ASSERT(t)
#  define USER_CHECK(code) {code}

#else /* !USER_DEBUG */

#  define USER_ASSERT(p) ((void)0)
#  define USER_CHECK(code) ((void)0)

#endif /* !USER_DEBUG */


#endif /* EME__DEBUG__ */

