/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#include "cpercent.h"

#include "debug.h"
#include "utils.h"
#include "ustring.h"
#include "translat.h"

#include "entry.h"

#include "ustring.h"
#include "alclean.h"

#include <altheme.h>

#include <allegro.h>



/* Creator
   ---------------------------------*/
Percent::Creator::Creator(StaticString *name, int max, int v):
  BaseCreator(name, new Property(v)), max_(max)
{
  DBG_SET_CREATOR_TYPE("Percent");
}


Percent::Creator *Percent::Creator::Clone(void) const
{
  return new Creator(this);
}


Percent::Creator::~Creator(void)
{
}


void Percent::Creator::Draw(
  const BaseProperty *p, BITMAP *bmp, int x, int y, int w, int h,
  float scale, int l, int i, int j
) const
{
  DBG_ASSERT(IsSameType(p));
  const Property *pn = ::Cast<Percent>(p);
  Number::Draw(pn->Get(), bmp, x, y, w, h);
}


int Percent::Creator::PrintValue(
  const BaseProperty *p, BITMAP *bmp, int x, int y, int color
) const
{
  DBG_ASSERT(IsSameType(p));
  const Property *pn = ::Cast<Percent>(p);
  textprintf(
    bmp, font, x, y, color, Translation("%s: Percent %d/%d"),
    GetName()->string(), pn->Get(), max_
  );
  return 1;
}


void Percent::Creator::UpdateEntry(Entry *e, const BaseProperty *p) const
{
  DBG_ASSERT(IsSameType(p));
  const Property *pn = ::Cast<Percent>(p);
  e->SetState(
    GetName()->string(), altheme_slider_proc, max_, pn->Get(),
    NULL, NULL, NULL, 0
  );
}


void Percent::Creator::UpdateProperty(BaseProperty *p, const Entry *e) const
{
  DBG_ASSERT(IsSameType(p));
  Property *pn = ::Cast<Percent>(p);
  pn->Set(e->GetD2State());
}

