/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#ifndef EME__COMMAND__
#define EME__COMMAND__
/*----------------------------------------------------------------------------
  An undoable command - abstract class

  A Command represent a command issued by the user. They can be kept so it is
possible to undo and redo them. Be very careful when creating new commands:
for example if your UnExecute function does nothing, after a number of undo/redo
the map state may become incoherent.

- Constructor/destructor
- Execution
----------------------------------------------------------------------------*/

#include "debug.h"

class Command {

public:
  /* Constructor/Destructor
     ---------------------------------*/
  Command(void) {}
  virtual ~Command(void) {}

  /* Execution
     ---------------------------------*/
  /* Executes the command
   */
  virtual void UnExecute(void)=0;

  /* Un-executes the command
   */
  virtual void Execute(void)=0;

  /* Returns true (1) if would do nothing in Execute and UnExecute,
     else false (0)
   */
  virtual int IsEmpty(void) const = 0;

  /* Merge 'cmd' with itself, returns true if has succeded
   */
  virtual int Merge(Command * /*cmd*/)
    {return 0;}

protected:

private:
};

#endif /* EME__COMMAND__ */

