/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#ifndef EME__NUMBER_TYPE__
#define EME__NUMBER_TYPE__
/*----------------------------------------------------------------------------
  Number Property

  - Types
  - Casts
  - Misc
  - Property
  - Creator
  - Private
----------------------------------------------------------------------------*/

#include "debug.h"
#include "utils.h"

#include "creator.h"
#include "prop.h"

#include "template.h"

class Entry;



struct Number {
  /* Types
     ---------------------------------*/
  class Creator;
  //class Property;
  typedef int Base;   /* The base type is an integer */
  typedef void Param; /* No additional parameter */
  typedef TemplateProperty<Base> Property;


#ifdef EME__COMPATIBILITY
  /* Casts
     So you can write: n = Number::Cast(p)
     which is more beautiful than: n = dynamic_cast<Number::Property*>(p)
     Note that this is now changed to: n = Cast<Number>(p)
     ---------------------------------*/
  static inline Property *Cast(BaseProperty *p)
    { return DYNAMIC_CAST(Property*, p); }
  static inline const Property *Cast(const BaseProperty *p)
    { return DYNAMIC_CAST(const Property*, p); }

  static inline Creator *Cast(BaseCreator *c)
    { return DYNAMIC_CAST(Creator*, c); }
  static inline const Creator *Cast(const BaseCreator *c)
    { return DYNAMIC_CAST(const Creator*, c); }
#endif


  /* Misc
     The drawing function (on a map) can be used by other properties (for
     example Percent::Property).
     ---------------------------------*/
  static void Draw(int value, BITMAP *bmp, int x, int y, int w, int h);


  /* Property
     ---------------------------------*/
#if 0
  friend class Property: public BaseProperty {

  public:
    /* Constructor/destructor
       --------------------*/
    //Property(int value): BaseProperty(), value_(value)
    Property(Base value): BaseProperty(), value_(value)
      {DBG_SET_PROP_TYPE("Number");}
    ~Property(void);
    Property *Clone(void) const;

    /* Accessors
       These two functions are required to be able to use the Wrapper
       --------------------*/
    //void Set(int v)         /* void Set(Base value) */
    void Set(Base v)
      {value_=v;}
    //int Get(void) const     /* Base Get(void) const */
    Base Get(void) const
      {return value_;}

    /* Using the property value
       --------------------*/
    void CopyFrom(const BaseProperty *p);
    int IsEqualTo(const BaseProperty *p) const;

  private:
    Property(const Property&);
    Property &operator=(const Property&);

    //int value_;
    Base value_;
  }; /* class Number::Property */
#endif


  /* Creator
     ---------------------------------*/
  friend class Creator: public BaseCreator {

  public:
    /* Constructor/destructor
       --------------------*/
    Creator(StaticString *name, int v);
    Creator *Clone(void) const;
    ~Creator(void);

    /* Properties
       --------------------*/
    Property *Create(int value) const
      { return new Property(value); }

    virtual void Draw(
      const BaseProperty *p, BITMAP *bmp, int x, int y, int w, int h,
      float scale, int l, int i, int j
    ) const;
    virtual int PrintValue(
      const BaseProperty *p, BITMAP *bmp, int x, int y, int color
    ) const;


    /* Entry handlers
       --------------------*/
    void UpdateEntry(Entry *e, const BaseProperty *p) const;
    void UpdateProperty(BaseProperty *p, const Entry *e) const;

  protected:
    Creator(StaticString *name, Property *ref);
    Creator(const Creator *other): BaseCreator(other)
      {DBG_SET_CREATOR_TYPE("Number"); Init(other->str_);}
    void Init(const char *str);

  private:
    Creator(const Creator&);
    Creator &operator=(const Creator&);

    inline const Property *ReferenceProperty(void) const
      { return ::Cast<Number>(GetReference()); }
    inline Property *ReferenceProperty(void)
      { return ::Cast<Number>(GetVariableReference()); }

    char *str_; /* String for the entry */
  }; /* class Number::Creator */


  /* Private
     ---------------------------------*/
private:
}; /* struct Number */

#ifdef DEBUG
typedef Number::Property NumberProperty;
typedef Number::Creator NumberCreator;
#endif

#endif /* EME__NUMBER_TYPE__ */

