/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#ifndef EME__CMD_LAYER__
#define EME__CMD_LAYER__

#include "debug.h"

#include "command.h"

class Map;
class Tiles;
class CommandGroup;
class ViewedLayers;

class CommandInsertLayer: public Command {

public:
  CommandInsertLayer(Map *map, Tiles *layer, int l);
  ~CommandInsertLayer();

  void UnExecute();
  void Execute();

  int IsEmpty() const;

private:
  CommandInsertLayer(const CommandInsertLayer&);
  CommandInsertLayer &operator=(const CommandInsertLayer&);

  Map *map_;
  Tiles *layer_;
  int l_;
};


class CommandRemoveLayer: public Command {

public:
  CommandRemoveLayer(Map *map, int l);
  ~CommandRemoveLayer();

  void UnExecute();
  void Execute();

  int IsEmpty() const;

private:
  CommandRemoveLayer(const CommandRemoveLayer&);
  CommandRemoveLayer &operator=(const CommandRemoveLayer&);

  Map *map_;
  Tiles *layer_;
  int l_;
};


class CommandSwapLayers: public Command {

public:
  CommandSwapLayers(Map *map, int l1, int l2);
  ~CommandSwapLayers();

  void UnExecute();
  void Execute();

  int IsEmpty() const;

private:
  CommandSwapLayers(const CommandSwapLayers&);
  CommandSwapLayers &operator=(const CommandSwapLayers&);

  Map *map_;
  int l1_;
  int l2_;
  CommandGroup *group_;
};


/* Merge all selected layers in 'layers'.
 * This will merge only layers which type is the same than the first selected
 * layer
 */
class CommandMergeLayers: public Command {

public:
  CommandMergeLayers(Map *map, const ViewedLayers &layers);
  ~CommandMergeLayers();

  void UnExecute();
  void Execute();

  int IsEmpty() const;

private:
  CommandMergeLayers(const CommandMergeLayers&);
  CommandMergeLayers &operator=(const CommandMergeLayers&);

  CommandGroup *group_;
};


class CommandReplaceLayer: public Command {

public:
  CommandReplaceLayer(Map *map, Tiles *layer, int l);
  ~CommandReplaceLayer();

  void UnExecute();
  void Execute();

  int IsEmpty() const;

private:
  CommandReplaceLayer(const CommandReplaceLayer&);
  CommandReplaceLayer &operator=(const CommandReplaceLayer&);

  CommandGroup *group_;
};

#endif /* EME__CMD_LAYER__ */

