/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#include "cmdcut.h"

#include "debug.h"
#include "utils.h"

#include "selected.h"
#include "lutils.h"
#include "stiles.h"
#include "map.h"


CommandCut::CommandCut(Map *map, int l, const SelectedTiles *sel_tiles): Command()
{
  /* Get the layer to work on */
  layer_ = map->GetLayer(l);

  /* Save the selection, which will be used in Execute */
  selection_ = sel_tiles->Clone();
  CHECK_POINTER(selection_);

  /* Save the tiles that will be cut, to be used in UnExecute */
  saved_tiles_ = LayerUtils::Copy(layer_, sel_tiles);
  CHECK_POINTER(saved_tiles_);
}

CommandCut::~CommandCut(void)
{
  /* Cleanup */
  delete selection_;
  delete saved_tiles_;
}


void CommandCut::Execute(void)
{
  /* Cut the selection from the layer */
  LayerUtils::Cut(layer_, selection_);
}

void CommandCut::UnExecute(void)
{
  /* Paste the saved tiles on the layer */
  LayerUtils::Paste(layer_, saved_tiles_->begini(), saved_tiles_->beginj(), saved_tiles_);
}


int CommandCut::IsEmpty(void) const
{
  /* If the selection was empty, the command will do nothing */
  if (selection_->Empty()) {
    return 1;
  }

  /* If no tiles were saved, the command will do nothing */
  if (saved_tiles_->count()==0) {
    return 1;
  }

  /* The command will do something */
  return 0;
}

