/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#ifndef EME__COMMAND_APPLY__
#define EME__COMMAND_APPLY__
/*----------------------------------------------------------------------------
  Apply and Draw point command:

  applies a value to a tile or a group of tiles in the current layer.
----------------------------------------------------------------------------*/

#include "debug.h"

#include "command.h"

class BaseProperty;
class SelectedTiles;
class Tiles;
class SparseTiles;
class Map;

#define FILL_PROBA_MAX 100

#define MAX_MERGE_ID (1<<24)

class CommandApply: public Command {

public:
  /* Probability between 0 and 100 (inclusive) */
  CommandApply(
    Map *map, int l,
    const SelectedTiles *tiles,    /* Tiles to modify */
    const BaseProperty *value,
    int id=MAX_MERGE_ID,           /* Command id (for Merge) */
    int probability=FILL_PROBA_MAX /* Probability to modify a tile */
  );
  CommandApply(
    Map *map, int l,
    int x, int y,                  /* Tile to modify */
    const BaseProperty *value,
    int id=MAX_MERGE_ID            /* Command id (for Merge) */
  );
  ~CommandApply(void);

  void Execute(void);
  void UnExecute(void);

  int Merge(Command *cmd);

  int IsEmpty(void) const;

protected:

private:
  CommandApply(const CommandApply&);
  CommandApply &operator=(const CommandApply&);

  int id_;                           /* Can merge commands with same id */
  int probability_;                  /* Proba of modifying a tile */
  SelectedTiles *tiles_;             /* Selected tiles position when the cmd is issued */
  SparseTiles *saved_tiles_;         /* Selected tiles value before cmd execution */
  SelectedTiles *saved_empty_tiles_; /* Empty tiles that will be set */
  Tiles *layer_;                     /* Current layer when the cmd is issued */
  BaseProperty *tile_value_;         /* Value to apply to the selected tiles */
};

#endif /* EME__COMMAND_APPLY__ */

