/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#ifndef EME__BRUSH__
#define EME__BRUSH__
/*----------------------------------------------------------------------------
  Brush

  Allows to copy, paste, save more than one layer
----------------------------------------------------------------------------*/

#include "debug.h"

class TilesStack;
class SparseTiles;
class SelectedTiles;
class ViewedLayers;

class Brush {

public:
  /* Creates an empty brush */
  Brush(int num_layers);

  Brush();

  /* Creates a brush from the selected tiles and the layers with value true */
  Brush(
    const TilesStack *map,
    const ViewedLayers *layers, /* Which layers should be put in brush ? */
    const SelectedTiles *sel  /* Area to put in brush */
  );

  ~Brush(void);

  Brush *Clone(void) const
    { return new Brush(*this); }

  /* Replace the 'l'th layer by 'tiles', Brush takes the ownership of 'tiles' */
  void SetLayer(int l, SparseTiles *tiles);

  /* Remove the 'l'th layer */
  void ClearLayer(int l);

  int GetNumLayers(void) const;

  const SparseTiles *GetLayer(int l) const;

  /* Tile indices must be positive or 0 */
  int MinX(void) const;
  int MinY(void) const;
  int MaxX(void) const;
  int MaxY(void) const;

  void MoveLayers(int di, int dj);

protected:
  Brush(const Brush &other);

private:
  Brush &operator=(const Brush&);

  TilesStack *layers_;
};


#endif /* EME__BRUSH__ */

